/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.VoidProtectionHelper;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_ParallelHelper {
    private static final double MAX_BATCH_MODE_TICK_TIME = 128.0;
    private IVoidable machine;
    private IRecipeLockable singleRecipeMachine;
    private boolean isRecipeLocked;
    private GT_Recipe recipe;
    private long availableEUt;
    private int currentParallel = 0;
    private int maxParallel = 1;
    private int batchModifier = 1;
    private ItemStack[] itemInputs;
    private ItemStack[] itemOutputs;
    private FluidStack[] fluidInputs;
    private FluidStack[] fluidOutputs;
    private boolean protectExcessItem;
    private boolean protectExcessFluid;
    private boolean consume;
    private boolean batchMode;
    private boolean calculateOutputs;
    private boolean built;
    private double durationMultiplier;
    private float eutModifier = 1.0f;
    private GT_OverclockCalculator calculator;
    private CheckRecipeResult result = CheckRecipeResultRegistry.NONE;
    private Function<Integer, ItemStack[]> customItemOutputCalculation;
    private Function<Integer, FluidStack[]> customFluidOutputCalculation;

    @Deprecated
    public GT_ParallelHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta) {
        return this.setMachine(machineMeta, machineMeta.protectsExcessItem(), machineMeta.protectsExcessFluid());
    }

    @Deprecated
    public GT_ParallelHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta, boolean protectExcessItem, boolean protectExcessFluid) {
        return this.setMachine(machineMeta, protectExcessItem, protectExcessFluid);
    }

    public GT_ParallelHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    public GT_ParallelHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    public GT_ParallelHelper setRecipe(@Nonnull GT_Recipe aRecipe) {
        this.recipe = Objects.requireNonNull(aRecipe);
        return this;
    }

    public GT_ParallelHelper setRecipeLocked(IRecipeLockable singleRecipeMachine, boolean isRecipeLocked) {
        this.singleRecipeMachine = singleRecipeMachine;
        this.isRecipeLocked = isRecipeLocked;
        return this;
    }

    public GT_ParallelHelper setItemInputs(ItemStack ... aItemInputs) {
        this.itemInputs = aItemInputs;
        return this;
    }

    public GT_ParallelHelper setFluidInputs(FluidStack ... aFluidInputs) {
        this.fluidInputs = aFluidInputs;
        return this;
    }

    public GT_ParallelHelper setAvailableEUt(long aAvailableEUt) {
        this.availableEUt = aAvailableEUt;
        return this;
    }

    public GT_ParallelHelper setEUtModifier(float aEUtModifier) {
        this.eutModifier = aEUtModifier;
        return this;
    }

    public GT_ParallelHelper setCalculator(GT_OverclockCalculator calculator) {
        this.calculator = calculator;
        return this;
    }

    @Deprecated
    public GT_ParallelHelper enableConsumption() {
        return this.setConsumption(true);
    }

    public GT_ParallelHelper setConsumption(boolean consume) {
        this.consume = consume;
        return this;
    }

    public GT_ParallelHelper setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public GT_ParallelHelper enableBatchMode(int batchModifier) {
        this.batchMode = batchModifier > 1;
        this.batchModifier = batchModifier;
        return this;
    }

    @Deprecated
    public GT_ParallelHelper enableOutputCalculation() {
        return this.setOutputCalculation(true);
    }

    public GT_ParallelHelper setOutputCalculation(boolean calculateOutputs) {
        this.calculateOutputs = calculateOutputs;
        return this;
    }

    public GT_ParallelHelper setCustomItemOutputCalculation(Function<Integer, ItemStack[]> custom) {
        this.customItemOutputCalculation = custom;
        return this;
    }

    public GT_ParallelHelper setCustomFluidOutputCalculation(Function<Integer, FluidStack[]> custom) {
        this.customFluidOutputCalculation = custom;
        return this;
    }

    public GT_ParallelHelper build() {
        if (this.built) {
            throw new IllegalStateException("Tried to build twice");
        }
        if (this.recipe == null) {
            throw new IllegalStateException("Recipe is not set");
        }
        this.built = true;
        this.determineParallel();
        return this;
    }

    public int getCurrentParallel() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.currentParallel;
    }

    public double getDurationMultiplierDouble() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get duration multiplier before building");
        }
        if (this.batchMode && this.durationMultiplier > 0.0) {
            return this.durationMultiplier;
        }
        return 1.0;
    }

    @Deprecated
    public float getDurationMultiplier() {
        return (float)this.getDurationMultiplierDouble();
    }

    @Nonnull
    public ItemStack[] getItemOutputs() {
        if (!this.built || !this.calculateOutputs) {
            throw new IllegalStateException("Tried to get item outputs before building or without enabling calculation of outputs");
        }
        return this.itemOutputs;
    }

    @Nonnull
    public FluidStack[] getFluidOutputs() {
        if (!this.built || !this.calculateOutputs) {
            throw new IllegalStateException("Tried to get fluid outputs before building or without enabling calculation of outputs");
        }
        return this.fluidOutputs;
    }

    @Nonnull
    public CheckRecipeResult getResult() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get recipe result before building");
        }
        return this.result;
    }

    @Deprecated
    protected boolean tryConsumeRecipeInputs(GT_Recipe recipe, FluidStack[] fluids, ItemStack[] items) {
        return this.tryConsumeRecipeInputs(recipe, fluids, items, 1);
    }

    protected boolean tryConsumeRecipeInputs(GT_Recipe recipe, FluidStack[] fluids, ItemStack[] items, int minParallel) {
        return recipe.isRecipeInputEqual(true, false, minParallel, fluids, items);
    }

    protected void determineParallel() {
        GT_Recipe.GT_Recipe_Map recipeMap;
        int originalMaxParallel;
        double tickTimeAfterOC;
        int tRecipeEUt;
        if (this.itemInputs == null) {
            this.itemInputs = new ItemStack[0];
        }
        if (this.fluidInputs == null) {
            this.fluidInputs = new FluidStack[0];
        }
        if (!this.consume) {
            this.copyInputs();
        }
        if (this.calculator == null) {
            this.calculator = new GT_OverclockCalculator().setEUt(this.availableEUt).setRecipeEUt(this.recipe.mEUt).setDuration(this.recipe.mDuration).setEUtDiscount(this.eutModifier);
        }
        if (this.availableEUt < (long)(tRecipeEUt = (int)Math.ceil((float)this.recipe.mEUt * this.eutModifier))) {
            this.result = CheckRecipeResultRegistry.insufficientPower(tRecipeEUt);
        }
        if ((tickTimeAfterOC = this.calculator.setParallel(originalMaxParallel = this.maxParallel).calculateDurationUnderOneTick()) < 1.0) {
            this.maxParallel = (int)((double)this.maxParallel / tickTimeAfterOC);
        }
        int maxParallelBeforeBatchMode = this.maxParallel;
        if (this.batchMode) {
            this.maxParallel *= this.batchModifier;
        }
        SingleRecipeCheck recipeCheck = null;
        SingleRecipeCheck.Builder tSingleRecipeCheckBuilder = null;
        if (this.isRecipeLocked && this.singleRecipeMachine != null && (recipeCheck = this.singleRecipeMachine.getSingleRecipeCheck()) == null && (recipeMap = this.singleRecipeMachine.getRecipeMap()) != null) {
            tSingleRecipeCheckBuilder = SingleRecipeCheck.builder(recipeMap).setBefore(this.itemInputs, this.fluidInputs);
        }
        if (this.protectExcessItem || this.protectExcessFluid) {
            if (this.machine == null) {
                throw new IllegalStateException("Tried to calculate void protection, but machine is not set");
            }
            VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
            voidProtectionHelper.setMachine(this.machine).setItemOutputs(this.recipe.mOutputs).setFluidOutputs(this.recipe.mFluidOutputs).setMaxParallel(this.maxParallel).build();
            this.maxParallel = Math.min(voidProtectionHelper.getMaxParallel(), this.maxParallel);
            if (this.maxParallel <= 0) {
                this.result = CheckRecipeResultRegistry.OUTPUT_FULL;
                return;
            }
        }
        maxParallelBeforeBatchMode = Math.min(this.maxParallel, maxParallelBeforeBatchMode);
        if (recipeCheck != null) {
            int actualMaxParallel = (int)Math.min((long)maxParallelBeforeBatchMode, this.availableEUt / (long)tRecipeEUt);
            this.currentParallel = recipeCheck.checkRecipeInputs(true, actualMaxParallel, this.itemInputs, this.fluidInputs);
        } else {
            long tCurrentUsage = 0L;
            boolean builtRecipeCheck = false;
            while (this.currentParallel < maxParallelBeforeBatchMode && tCurrentUsage < this.availableEUt - (long)tRecipeEUt && this.tryConsumeRecipeInputs(this.recipe, this.fluidInputs, this.itemInputs)) {
                tCurrentUsage += (long)tRecipeEUt;
                if (tSingleRecipeCheckBuilder != null && !builtRecipeCheck) {
                    SingleRecipeCheck builtCheck = tSingleRecipeCheckBuilder.setAfter(this.itemInputs, this.fluidInputs).setRecipe(this.recipe).build();
                    this.singleRecipeMachine.setSingleRecipeCheck(builtCheck);
                    builtRecipeCheck = true;
                }
                ++this.currentParallel;
            }
        }
        if (this.currentParallel <= 0) {
            this.result = CheckRecipeResultRegistry.INTERNAL_ERROR;
            return;
        }
        long eutUseAfterOC = this.calculator.calculateEUtConsumptionUnderOneTick(originalMaxParallel, this.currentParallel);
        this.calculator.setParallel(Math.min(this.currentParallel, originalMaxParallel)).calculate();
        if (this.currentParallel > originalMaxParallel) {
            this.calculator.setRecipeEUt(eutUseAfterOC);
        }
        if (this.batchMode && this.currentParallel > 0 && (double)this.calculator.getDuration() < 128.0) {
            int tExtraParallels;
            double batchMultiplierMax = 128.0 / (double)this.calculator.getDuration();
            int maxExtraParallels = (int)Math.floor(Math.min((double)this.currentParallel * Math.min(batchMultiplierMax - 1.0, (double)(this.batchModifier - 1)), (double)(this.maxParallel - this.currentParallel)));
            if (recipeCheck != null) {
                tExtraParallels = recipeCheck.checkRecipeInputs(true, maxExtraParallels, this.itemInputs, this.fluidInputs);
            } else {
                for (tExtraParallels = 0; tExtraParallels < maxExtraParallels && this.tryConsumeRecipeInputs(this.recipe, this.fluidInputs, this.itemInputs, this.currentParallel); tExtraParallels += this.currentParallel) {
                }
            }
            this.durationMultiplier = 1.0f + (float)tExtraParallels / (float)this.currentParallel;
            this.currentParallel += tExtraParallels;
        }
        if (this.calculateOutputs && this.currentParallel > 0) {
            if (this.recipe.mOutputs != null) {
                this.calculateItemOutputs();
            }
            if (this.recipe.mFluidOutputs != null) {
                this.calculateFluidOutputs();
            }
        }
        this.result = CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected void copyInputs() {
        int i;
        ItemStack[] itemInputsToUse = new ItemStack[this.itemInputs.length];
        for (i = 0; i < this.itemInputs.length; ++i) {
            itemInputsToUse[i] = this.itemInputs[i].func_77946_l();
        }
        FluidStack[] fluidInputsToUse = new FluidStack[this.fluidInputs.length];
        for (i = 0; i < this.fluidInputs.length; ++i) {
            fluidInputsToUse[i] = this.fluidInputs[i].copy();
        }
        this.itemInputs = itemInputsToUse;
        this.fluidInputs = fluidInputsToUse;
    }

    protected void calculateItemOutputs() {
        if (this.customItemOutputCalculation != null) {
            this.itemOutputs = this.customItemOutputCalculation.apply(this.currentParallel);
            return;
        }
        this.itemOutputs = new ItemStack[this.recipe.mOutputs.length];
        for (int i = 0; i < this.recipe.mOutputs.length; ++i) {
            if (this.recipe.getOutputChance(i) >= 10000) {
                ItemStack item = this.recipe.getOutput(i).func_77946_l();
                item.field_77994_a *= this.currentParallel;
                this.itemOutputs[i] = item;
                continue;
            }
            int items = 0;
            int itemStackSize = this.recipe.getOutput((int)i).field_77994_a;
            for (int roll = 0; roll < this.currentParallel; ++roll) {
                if (this.recipe.getOutputChance(i) <= XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                items += itemStackSize;
            }
            ItemStack item = this.recipe.getOutput(i).func_77946_l();
            if (items == 0) {
                item = null;
            } else {
                item.field_77994_a = items;
            }
            this.itemOutputs[i] = item;
        }
    }

    protected void calculateFluidOutputs() {
        if (this.customFluidOutputCalculation != null) {
            this.fluidOutputs = this.customFluidOutputCalculation.apply(this.currentParallel);
            return;
        }
        this.fluidOutputs = new FluidStack[this.recipe.mFluidOutputs.length];
        for (int i = 0; i < this.recipe.mFluidOutputs.length; ++i) {
            if (this.recipe.getFluidOutput(i) == null) {
                this.fluidOutputs[i] = null;
                continue;
            }
            FluidStack tFluid = this.recipe.getFluidOutput(i).copy();
            tFluid.amount *= this.currentParallel;
            this.fluidOutputs[i] = tFluid;
        }
    }
}

