/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import ic2.core.IHasGui;
import ic2.core.item.ItemToolbox;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Maintenance
extends GT_MetaTileEntity_Hatch
implements IAddUIWidgets {
    private static ItemStack[] sAutoMaintenanceInputs;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mAuto;

    public GT_MetaTileEntity_Hatch_Maintenance(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "For maintaining Multiblocks", new ITexture[0]);
        this.mAuto = false;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(int aID, String aName, String aNameRegional, int aTier, boolean aAuto) {
        super(aID, aName, aNameRegional, aTier, 4, "For automatically maintaining Multiblocks", new ITexture[0]);
        this.mAuto = aAuto;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(String aName, int aTier, String aDescription, ITexture[][][] aTextures, boolean aAuto) {
        super(aName, aTier, aAuto ? 4 : 1, aDescription, aTextures);
        this.mAuto = aAuto;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, boolean aAuto) {
        super(aName, aTier, aAuto ? 4 : 1, aDescription, aTextures);
        this.mAuto = aAuto;
    }

    private static ItemStack[] getAutoMaintenanceInputs() {
        if (sAutoMaintenanceInputs == null) {
            sAutoMaintenanceInputs = new ItemStack[]{ItemList.Duct_Tape.get(4L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.cell, Materials.Lubricant, 2L), GT_OreDictUnificator.get(OrePrefixes.screw, Materials.Steel, 4L), GT_OreDictUnificator.get(OrePrefixes.circuit, Materials.Advanced, 2L)};
        }
        return sAutoMaintenanceInputs;
    }

    @Override
    public String[] getDescription() {
        String[] desc;
        if (this.mAuto) {
            desc = new String[this.mDescriptionArray.length + 3];
            System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
            desc[this.mDescriptionArray.length] = "4 Ducttape, 2 Lubricant Cells";
            desc[this.mDescriptionArray.length + 1] = "4 Steel Screws, 2 HV Circuits";
            desc[this.mDescriptionArray.length + 2] = "For each autorepair";
        } else {
            desc = new String[this.mDescriptionArray.length + 1];
            System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
            desc[this.mDescriptionArray.length] = "Cannot be shared between Multiblocks!";
        }
        return desc;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE_GLOW).glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MAINTENANCE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_GLOW).glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MAINTENANCE), TextureFactory.of(Textures.BlockIcons.OVERLAY_DUCTTAPE)};
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity.getMetaTileID() == 111) {
            return new GT_MetaTileEntity_Hatch_Maintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, true);
        }
        return new GT_MetaTileEntity_Hatch_Maintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, false);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (side == aBaseMetaTileEntity.getFrontFacing()) {
            if (aPlayer instanceof FakePlayer && !aPlayer.func_146103_bH().getName().endsWith(".robot")) {
                return false;
            }
            ItemStack tStack = aPlayer.func_71045_bC();
            if (tStack != null) {
                if (tStack.func_77973_b() instanceof ItemToolbox) {
                    this.applyToolbox(tStack, aPlayer);
                } else if (ItemList.Duct_Tape.isStackEqual(tStack)) {
                    this.mSolderingTool = true;
                    this.mCrowbar = true;
                    this.mHardHammer = true;
                    this.mSoftHammer = true;
                    this.mScrewdriver = true;
                    this.mWrench = true;
                    this.getBaseMetaTileEntity().setActive(false);
                    if (--tStack.field_77994_a == 0) {
                        aPlayer.field_71071_by.field_70462_a[aPlayer.field_71071_by.field_70461_c] = null;
                    }
                } else {
                    GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
                }
            } else {
                GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            }
            return true;
        }
        return false;
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mAuto && aTick % 100L == 0L) {
            aBaseMetaTileEntity.setActive(!this.isRecipeInputEqual(false));
        }
    }

    public boolean autoMaintainance() {
        return this.isRecipeInputEqual(true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess) {
        int amt;
        ItemStack[] mInputs;
        for (ItemStack tStack : mInputs = GT_MetaTileEntity_Hatch_Maintenance.getAutoMaintenanceInputs()) {
            if (tStack == null) continue;
            amt = tStack.field_77994_a;
            boolean temp = true;
            ItemStack[] itemStackArray = this.mInventory;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack aStack = itemStackArray[i];
                if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true) || (amt -= aStack.field_77994_a) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            block2: for (ItemStack tStack : mInputs) {
                if (tStack == null) continue;
                amt = tStack.field_77994_a;
                for (ItemStack aStack : this.mInventory) {
                    if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true)) continue;
                    if (aStack.field_77994_a < amt) {
                        amt -= aStack.field_77994_a;
                        aStack.field_77994_a = 0;
                        continue;
                    }
                    aStack.field_77994_a -= amt;
                    amt = 0;
                    continue block2;
                }
            }
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mSolderingTool = true;
            this.mWrench = true;
            this.updateSlots();
        }
        return true;
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer, IInventory aToolboxInventory) {
        if (aStack == null || aPlayer == null) {
            return;
        }
        if (aStack.func_77973_b() instanceof ItemToolbox && aPlayer instanceof EntityPlayer) {
            this.applyToolbox(aStack, (EntityPlayer)aPlayer);
            return;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sWrenchList) && !this.mWrench && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mWrench = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sScrewdriverList) && !this.mScrewdriver && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mScrewdriver = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSoftHammerList) && !this.mSoftHammer && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mSoftHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sHardHammerList) && !this.mHardHammer && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mHardHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sCrowbarList) && !this.mCrowbar && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mCrowbar = true;
        }
        if (!this.mSolderingTool && GT_ModHandler.useSolderingIron(aStack, aPlayer, aToolboxInventory)) {
            this.mSolderingTool = true;
        }
        if (GT_OreDictUnificator.isItemStackInstanceOf(aStack, "craftingDuctTape")) {
            this.mSolderingTool = true;
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mSoftHammer = true;
            this.mScrewdriver = true;
            this.mWrench = true;
            this.getBaseMetaTileEntity().setActive(false);
            --aStack.field_77994_a;
        }
        if (this.mSolderingTool && aPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP tPlayer = (EntityPlayerMP)aPlayer;
            try {
                GT_Mod.achievements.issueAchievement((EntityPlayer)tPlayer, "maintainance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer) {
        this.onToolClick(aStack, aPlayer, null);
    }

    private void applyToolbox(ItemStack aStack, EntityPlayer aPlayer) {
        ItemToolbox aToolbox = (ItemToolbox)aStack.func_77973_b();
        IHasGui aToolboxGUI = aToolbox.getInventory(aPlayer, aStack);
        for (int i = 0; i < aToolboxGUI.func_70302_i_(); ++i) {
            if (aToolboxGUI.func_70301_a(i) == null) continue;
            this.onToolClick(aToolboxGUI.func_70301_a(i), (EntityLivingBase)aPlayer, (IInventory)aToolboxGUI);
            if (aToolboxGUI.func_70301_a(i) == null || aToolboxGUI.func_70301_a((int)i).field_77994_a > 0) continue;
            aToolboxGUI.func_70299_a(i, null);
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (!GT_Utility.areStacksEqual(GT_OreDictUnificator.get(false, aStack), GT_OreDictUnificator.get(false, this.func_70301_a(i)))) continue;
                return i == aIndex;
            }
            for (ItemStack tInput : GT_MetaTileEntity_Hatch_Maintenance.getAutoMaintenanceInputs()) {
                if (!GT_Utility.areUnificationsEqual(tInput, aStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tInput, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mAuto) {
            this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
        } else {
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.SLOT_MAINTENANCE).setPos(78, 33).setSize(20, 20))).widget(new SlotWidget(BaseSlot.empty()){

                public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
                    return false;
                }

                protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                    if (cursorStack == null) {
                        return;
                    }
                    GT_MetaTileEntity_Hatch_Maintenance.this.onToolClick(cursorStack, (EntityLivingBase)this.getContext().getPlayer());
                    if (cursorStack.field_77994_a < 1) {
                        this.getContext().getPlayer().field_71071_by.func_70437_b(null);
                    }
                    if (this.getContext().getPlayer() instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.getContext().getPlayer()).func_71113_k();
                    }
                }
            }.disableShiftInsert().setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(79, 34))).widget(new TextWidget("Click with Tool to repair.").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(8, 12));
        }
    }
}

