/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.GT_GuiTab;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.interfaces.IGuiIcon;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GT_GuiTabLine {
    protected final GT_GuiTab[] mTabs;
    private final int tabLineLeft;
    private final int tabLineTop;
    private final int tabHeight;
    private final int tabWidth;
    private final int tabSpacing;
    private final DisplayStyle xDir;
    private final DisplayStyle yDir;
    protected final boolean flipHorizontally;
    protected final boolean visible;
    private final GT_GuiTabIconSet tabBackground;
    private final GT_ITabRenderer gui;

    public GT_GuiTabLine(GT_ITabRenderer gui, int numTabs, int tabLineLeft, int tabLineTop, int tabHeight, int tabWidth, int tabSpacing, DisplayStyle xDir, DisplayStyle yDir, DisplayStyle displayMode, GT_GuiTabIconSet tabBackground) {
        this.gui = gui;
        this.mTabs = new GT_GuiTab[numTabs];
        this.tabLineLeft = tabLineLeft;
        this.tabLineTop = tabLineTop;
        this.tabHeight = tabHeight;
        this.tabWidth = tabWidth;
        this.tabSpacing = tabSpacing;
        this.xDir = xDir;
        this.yDir = yDir;
        this.tabBackground = tabBackground;
        this.flipHorizontally = displayMode == DisplayStyle.INVERSE;
        this.visible = displayMode != DisplayStyle.NONE;
    }

    public void setTab(int tabId, ItemStack item, IGuiIcon overlay, String[] text) {
        this.mTabs[tabId] = new GT_GuiTab(this.gui, tabId, this.getBoundsForTab(tabId), this.tabBackground, item, overlay, text, this.flipHorizontally);
    }

    protected Rectangle getBoundsForTab(int tabId) {
        return new Rectangle(this.getTabX(tabId), this.getTabY(tabId), this.tabWidth, this.tabHeight);
    }

    public void setTabEnabled(int tabId, boolean enable) {
        if (this.mTabs[tabId] != null) {
            this.mTabs[tabId].enabled = enable;
        }
    }

    public void drawTabs(float parTicks, int mouseX, int mouseY) {
        if (this.visible) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.drawBackground(parTicks, mouseX, mouseY);
            this.drawOverlays(parTicks, mouseX, mouseY);
            GL11.glPopAttrib();
        }
    }

    protected void drawOverlays(float parTicks, int mouseX, int mouseY) {
        for (GT_GuiTab mTab : this.mTabs) {
            if (mTab == null) continue;
            mTab.drawOverlays(mouseX, mouseY, parTicks);
        }
    }

    protected void drawBackground(float parTicks, int mouseX, int mouseY) {
        for (GT_GuiTab mTab : this.mTabs) {
            if (mTab == null) continue;
            mTab.drawBackground(mouseX, mouseY, parTicks);
        }
    }

    public void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (int tabId = 0; tabId < this.mTabs.length; ++tabId) {
            if (this.mTabs[tabId] == null || !this.mTabs[tabId].getBounds().contains(mouseX, mouseY)) continue;
            this.tabClicked(tabId, mouseButton);
            return;
        }
    }

    protected void tabClicked(int tabId, int mouseButton) {
    }

    public void onInit() {
        for (int i = 0; i < this.mTabs.length; ++i) {
            if (this.mTabs[i] == null) continue;
            this.mTabs[i].setPosition(this.getTabX(i), this.getTabY(i));
        }
    }

    private int getTabX(int tabId) {
        return this.gui.getGuiLeft() + (this.flipHorizontally ? this.gui.getXSize() - this.tabLineLeft - this.tabWidth : this.tabLineLeft) + tabId * (this.tabWidth + this.tabSpacing) * this.xDir.getValue();
    }

    private int getTabY(int tabId) {
        return this.gui.getGuiTop() + this.tabLineTop + tabId * (this.tabHeight + this.tabSpacing) * this.yDir.getValue();
    }

    public static interface GT_ITabRenderer {
        public int getGuiLeft();

        public int getGuiTop();

        public int getXSize();

        public RenderItem getItemRenderer();

        public FontRenderer getFontRenderer();

        public void addToolTip(GT_GuiTooltip var1);

        public boolean removeToolTip(GT_GuiTooltip var1);
    }

    public static enum DisplayStyle {
        NONE(0),
        NORMAL(1),
        INVERSE(-1);

        private final byte value;

        private DisplayStyle(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static class GT_GuiTabIconSet {
        public IGuiIcon disabled;
        public IGuiIcon normal;
        public IGuiIcon highlight;

        public GT_GuiTabIconSet(IGuiIcon normalIcon, IGuiIcon highlightIcon, IGuiIcon disabledIcon) {
            this.normal = normalIcon;
            this.highlight = highlightIcon;
            this.disabled = disabledIcon;
        }
    }
}

