/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.bettercrashes.utils;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import org.apache.commons.lang3.StringUtils;
import vfyjxf.bettercrashes.BetterCrashesConfig;
import vfyjxf.bettercrashes.upload.CrashReportUpload;
import vfyjxf.bettercrashes.utils.CrashUtils;
import vfyjxf.bettercrashes.utils.IPatchedCrashReport;

@SideOnly(value=Side.CLIENT)
public abstract class GuiProblemScreen
extends GuiScreen {
    private static Field fieldClientCrashCount = null;
    private static Field fieldServerCrashCount = null;
    protected final CrashReport report;
    private volatile URL pasteLink = null;
    private String modListString;
    protected List<String> detectedUnsupportedModNames;

    public GuiProblemScreen(CrashReport report) {
        this.report = report;
    }

    public void func_73866_w_() {
        this.field_146297_k.func_71364_i();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m / 4 + 120 + 12, 110, 20, I18n.func_135052_a((String)"bettercrashes.gui.common.openCrashReport", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 50 + 115, this.field_146295_m / 4 + 120 + 12, 110, 20, I18n.func_135052_a((String)"bettercrashes.gui.common.uploadReportAndCopyLink", (Object[])new Object[0])));
        if (StringUtils.isNotEmpty((CharSequence)BetterCrashesConfig.issueTrackerURL)) {
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 50 - 15, this.field_146295_m / 4 + 120 + 12 + 25, 140, 20, I18n.func_135052_a((String)"bettercrashes.gui.common.issueTracker", (Object[])new Object[0])));
        }
    }

    protected void func_146284_a(final GuiButton button) {
        if (button.field_146127_k == 1) {
            try {
                CrashUtils.openCrashReport(this.report);
            }
            catch (IOException e) {
                button.field_146126_j = I18n.func_135052_a((String)"bettercrashes.gui.common.failed", (Object[])new Object[0]);
                button.field_146124_l = false;
                e.printStackTrace();
            }
        }
        if (button.field_146127_k == 2) {
            if (this.pasteLink == null) {
                button.field_146124_l = false;
                button.field_146126_j = I18n.func_135052_a((String)"bettercrashes.gui.common.uploading", (Object[])new Object[0]);
                Thread thread = new Thread("BetterCrashes report uploading"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            GuiProblemScreen.this.pasteLink = CrashReportUpload.uploadCrashReport(GuiProblemScreen.this.report.func_71502_e());
                            if (GuiProblemScreen.this.pasteLink != null) {
                                GuiScreen.func_146275_d((String)GuiProblemScreen.this.pasteLink.toString());
                            }
                            GuiButton guiButton = button;
                            synchronized (guiButton) {
                                button.field_146124_l = true;
                                button.field_146126_j = I18n.func_135052_a((String)"bettercrashes.gui.common.success", (Object[])new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            GuiButton guiButton = button;
                            synchronized (guiButton) {
                                button.field_146124_l = false;
                                button.field_146126_j = I18n.func_135052_a((String)"bettercrashes.gui.common.failed", (Object[])new Object[0]);
                            }
                        }
                    }
                };
                thread.start();
            } else {
                CrashUtils.openBrowser(this.pasteLink.toString());
            }
        }
        if (button.field_146127_k == 3) {
            CrashUtils.openBrowser(BetterCrashesConfig.issueTrackerURL);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
    }

    protected abstract String getScreenTitle();

    protected abstract String getScreenSummary();

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.detectedUnsupportedModNames == null) {
            this.detectedUnsupportedModNames = this.getUnsupportedMods();
        }
        boolean hasUnsupportedMods = !this.detectedUnsupportedModNames.isEmpty();
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.getScreenTitle(), this.field_146294_l / 2, this.field_146295_m / 4 - 40 - (hasUnsupportedMods ? 16 : 0), 0xFFFFFF);
        int textColor = 0xD0D0D0;
        int x = this.field_146294_l / 2 - 155;
        int y = this.field_146295_m / 4;
        if (hasUnsupportedMods) {
            y -= 32;
        }
        this.func_73731_b(this.field_146289_q, this.getScreenSummary(), x, y, textColor);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph1", (Object[])new Object[0]), x, y += 18, textColor);
        this.func_73732_a(this.field_146289_q, this.getModListString(), this.field_146294_l / 2, y += 11, 0xE0E000);
        if (this.isCrashLogExpectedToBeGenerated()) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph2", (Object[])new Object[0]), x, y += 11, textColor);
            this.func_73732_a(this.field_146289_q, this.report.func_71497_f() != null ? "\u00a7n" + this.report.func_71497_f().getName() : I18n.func_135052_a((String)"bettercrashes.gui.common.reportSaveFailed", (Object[])new Object[0]), this.field_146294_l / 2, y += 11, 65280);
        } else {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph6", (Object[])new Object[0]), x, y += 11, textColor);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph7", (Object[])new Object[0]), x, y += 11, textColor);
        }
        y += 12;
        y += this.drawLongString(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph3", (Object[])new Object[0]), x, y, 340, textColor);
        if (hasUnsupportedMods) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph4", (Object[])new Object[0]), x, y += 10, textColor);
            this.func_73732_a(this.field_146289_q, StringUtils.join(this.detectedUnsupportedModNames, (String)", "), this.field_146294_l / 2, y += 11, 0xE0E000);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"bettercrashes.gui.common.paragraph5", (Object[])new Object[0]), x, y += 12, textColor);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected String getModListString() {
        if (this.modListString == null) {
            Set<ModContainer> suspectedMods = ((IPatchedCrashReport)this.report).getSuspectedMods();
            if (suspectedMods == null) {
                this.modListString = I18n.func_135052_a((String)"bettercrashes.gui.common.identificationErrored", (Object[])new Object[0]);
                return this.modListString;
            }
            ArrayList<String> modNames = new ArrayList<String>();
            for (ModContainer mod : suspectedMods) {
                modNames.add(mod.getName());
            }
            this.modListString = modNames.isEmpty() ? I18n.func_135052_a((String)"bettercrashes.gui.common.unknownCause", (Object[])new Object[0]) : StringUtils.join(modNames, (String)", ");
        }
        return this.modListString;
    }

    protected int drawLongString(FontRenderer fontRenderer, String text, int x, int y, int width, int color) {
        int yOffset = 0;
        for (Object line : Minecraft.func_71410_x().field_71466_p.func_78271_c(text, width)) {
            this.func_73731_b(fontRenderer, (String)line, x, y + yOffset, color);
            yOffset += 9;
        }
        return yOffset;
    }

    protected List<String> getUnsupportedMods() {
        ArrayList<String> installedUnsupportedMods = new ArrayList<String>();
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!BetterCrashesConfig.unsupportedMods.contains(mod.getModId())) continue;
            installedUnsupportedMods.add(mod.getName());
        }
        if (FMLClientHandler.instance().hasOptifine()) {
            installedUnsupportedMods.add("Optifine");
        }
        return installedUnsupportedMods;
    }

    private int getClientCrashCount() {
        if (fieldClientCrashCount != null) {
            try {
                return (Integer)fieldClientCrashCount.get(Minecraft.func_71410_x());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private int getServerCrashCount() {
        if (fieldServerCrashCount != null) {
            try {
                return (Integer)fieldServerCrashCount.get(Minecraft.func_71410_x());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    protected boolean isCrashLogExpectedToBeGenerated() {
        return this.getClientCrashCount() <= BetterCrashesConfig.crashLogLimitClient && this.getServerCrashCount() <= BetterCrashesConfig.crashLogLimitServer;
    }

    static {
        try {
            fieldClientCrashCount = Minecraft.class.getDeclaredField("clientCrashCount");
            fieldClientCrashCount.setAccessible(true);
            fieldServerCrashCount = Minecraft.class.getDeclaredField("serverCrashCount");
            fieldServerCrashCount.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

