/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.asm;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import stevesaddons.api.IHiddenInventory;
import stevesaddons.api.IHiddenTank;
import stevesaddons.components.ComponentMenuTriggered;
import stevesaddons.helpers.StevesEnum;
import stevesaddons.naming.BlockCoord;
import stevesaddons.naming.NameRegistry;
import stevesaddons.reference.Null;
import stevesaddons.threading.SearchItems;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.ComponentHelper;
import vswe.stevesfactory.components.ComponentMenuItem;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.ComponentType;
import vswe.stevesfactory.components.Connection;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.ScrollController;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.settings.Settings;

public class StevesHooks {
    public static final Multimap<TileEntityManager, FlowComponent> delayedRegistry = HashMultimap.create();

    public static void addCopyButton(final TileEntityManager manager) {
        int index = StevesHooks.getAfterDelete(manager.buttons);
        List list = manager.buttons;
        TileEntityManager tileEntityManager = manager;
        tileEntityManager.getClass();
        list.add(index, new TileEntityManager.Button(tileEntityManager, StevesEnum.COPY_COMMAND){
            {
                TileEntityManager tileEntityManager2 = x0;
                tileEntityManager2.getClass();
                super(tileEntityManager2, x1);
            }

            protected void onClick(DataReader dataReader) {
                if (Settings.isLimitless((TileEntityManager)manager) || manager.getFlowItems().size() < 511) {
                    FlowComponent item;
                    int id = dataReader.readComponentId();
                    Iterator itr = manager.getFlowItems().iterator();
                    do {
                        if (itr.hasNext()) continue;
                        return;
                    } while ((item = (FlowComponent)itr.next()).getId() != id);
                    Collection added = StevesHooks.copyConnectionsWithChildren(manager.getFlowItems(), item, Settings.isLimitless((TileEntityManager)manager));
                    manager.getFlowItems().addAll(added);
                }
            }

            public boolean activateOnRelease() {
                return true;
            }

            public boolean onClick(DataWriter dataWriter) {
                FlowComponent item;
                Iterator itr = manager.getFlowItems().iterator();
                do {
                    if (itr.hasNext()) continue;
                    return false;
                } while (!(item = (FlowComponent)itr.next()).isBeingMoved());
                dataWriter.writeComponentId(manager, item.getId());
                return true;
            }

            public String getMouseOver() {
                return !Settings.isLimitless((TileEntityManager)manager) && manager.getFlowItems().size() == 511 ? Localization.MAXIMUM_COMPONENT_ERROR.toString() : super.getMouseOver();
            }
        });
    }

    private static int getAfterDelete(List<TileEntityManager.Button> buttons) {
        return ComponentType.values().length + 1;
    }

    private static Collection<FlowComponent> copyConnectionsWithChildren(List<FlowComponent> existing, FlowComponent toCopy, boolean limitless) {
        LinkedHashMap<FlowComponent, FlowComponent> added = new LinkedHashMap<FlowComponent, FlowComponent>();
        StevesHooks.copyConnectionsWithChildren(added, existing, toCopy, toCopy.getParent(), true);
        if (added.size() + existing.size() >= 511 && !limitless) {
            Iterator itr = added.entrySet().iterator();
            int index = 0;
            while (itr.hasNext()) {
                itr.next();
                if (index >= 511 - existing.size()) {
                    itr.remove();
                }
                ++index;
            }
        }
        StevesHooks.reconnect(added);
        return added.values();
    }

    private static void copyConnectionsWithChildren(Map<FlowComponent, FlowComponent> added, List<FlowComponent> existing, FlowComponent toCopy, FlowComponent newParent, boolean reset) {
        FlowComponent newComponent = toCopy.copy();
        newComponent.clearConnections();
        newComponent.setParent(newParent);
        if (reset) {
            newComponent.resetPosition();
            newComponent.setX(50);
            newComponent.setY(50);
        }
        newComponent.setId(existing.size() + added.size());
        added.put(toCopy, newComponent);
        for (FlowComponent component : existing) {
            if (component.getParent() != toCopy) continue;
            StevesHooks.copyConnectionsWithChildren(added, existing, component, newComponent, false);
        }
    }

    private static void reconnect(Map<FlowComponent, FlowComponent> added) {
        HashMap<Integer, FlowComponent> oldComponents = new HashMap<Integer, FlowComponent>();
        for (FlowComponent component : added.keySet()) {
            oldComponents.put(component.getId(), component);
        }
        block3: for (FlowComponent component : added.keySet()) {
            for (Map.Entry entry : component.getConnections().entrySet()) {
                try {
                    FlowComponent connectTo = added.get(oldComponents.get(((Connection)entry.getValue()).getComponentId()));
                    if (connectTo == null) continue;
                    Connection newConnection = new Connection(connectTo.getId(), ((Connection)entry.getValue()).getConnectionId());
                    added.get(component).setConnection(((Integer)entry.getKey()).intValue(), newConnection);
                }
                catch (NullPointerException ignored) {
                    continue block3;
                }
            }
        }
    }

    public static ItemStack fixLoadingStack(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == null) {
            return null;
        }
        return stack;
    }

    public static String fixToolTip(String string, TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.func_145830_o()) {
            String label = StevesHooks.getLabel(tileEntity);
            if (label != null) {
                string = "\u00a73" + label;
            }
            string = string + StevesHooks.getContentString(tileEntity);
        }
        return string;
    }

    public static void removeFlowComponent(TileEntityManager manager, int idToRemove, List<FlowComponent> components) {
        boolean isManagerList = manager.getFlowItems() == components;
        List<Integer> ids = StevesHooks.getIdsToRemove(idToRemove, components);
        ArrayList<FlowComponent> removed = new ArrayList<FlowComponent>();
        for (int id : ids) {
            int i;
            for (i = components.size() - 1; i >= 0; --i) {
                FlowComponent component = components.get(i);
                if (i == id) {
                    component.setParent(null);
                    removed.add(component);
                    components.remove(i);
                    continue;
                }
                component.updateConnectionIdsAtRemoval(id);
            }
            if (manager.getSelectedComponent() != null && manager.getSelectedComponent().getId() == id) {
                manager.setSelectedComponent(null);
            }
            for (i = id; i < components.size(); ++i) {
                components.get(i).decreaseId();
            }
        }
        if (isManagerList && manager.func_145831_w().field_72995_K) {
            for (FlowComponent remove : removed) {
                manager.getZLevelRenderingList().remove(remove);
            }
        }
    }

    public static List<Integer> getIdsToRemove(int idToRemove, List<FlowComponent> items) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        StevesHooks.getIdsToRemove(ids, idToRemove, items);
        Collections.sort(ids);
        Collections.reverse(ids);
        return ids;
    }

    private static void getIdsToRemove(List<Integer> ids, int idToRemove, List<FlowComponent> items) {
        for (FlowComponent component : items) {
            if (component.getParent() == null || component.getParent().getId() != idToRemove) continue;
            StevesHooks.getIdsToRemove(ids, component.getId(), items);
        }
        ids.add(idToRemove);
    }

    public static boolean instanceOf(Class clazz, TileEntity entity) {
        return clazz.isInstance(entity) || entity instanceof IHiddenTank && clazz == IFluidHandler.class || entity instanceof IHiddenInventory && clazz == IInventory.class || clazz == IEnergyConnection.class && (entity instanceof IEnergyProvider || entity instanceof IEnergyReceiver);
    }

    public static String getContentString(TileEntity tileEntity) {
        String result = "";
        if (tileEntity instanceof IDeepStorageUnit) {
            ItemStack stack = ((IDeepStorageUnit)tileEntity).getStoredItemType();
            String contains = "\n";
            contains = stack == null || stack.func_77969_a(Null.NULL_STACK) ? contains + StatCollector.func_74838_a((String)"stevesaddons.idsucompat.isEmpty") : contains + StatCollector.func_74837_a((String)"stevesaddons.idsucompat.contains", (Object[])new Object[]{stack.func_82833_r()});
            result = result + contains;
        } else if (tileEntity instanceof IFluidHandler) {
            String tankInfo = "";
            int i = 1;
            FluidTankInfo[] fluidTankInfo = ((IFluidHandler)tileEntity).getTankInfo(ForgeDirection.UNKNOWN);
            if (fluidTankInfo != null) {
                for (FluidTankInfo info : fluidTankInfo) {
                    if (info.fluid == null || info.fluid.getFluid() == null) {
                        return result;
                    }
                    tankInfo = tankInfo + info.fluid.getLocalizedName() + (i++ < fluidTankInfo.length ? ", " : "");
                }
            }
            result = tankInfo.isEmpty() ? result + "\n" + StatCollector.func_74838_a((String)"stevesaddons.idsucompat.isEmpty") : result + "\n" + StatCollector.func_74837_a((String)"stevesaddons.idsucompat.contains", (Object[])new Object[]{tankInfo});
        }
        return result;
    }

    private static String getLabel(TileEntity tileEntity) {
        BlockCoord coord = new BlockCoord(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        return NameRegistry.getSavedName(tileEntity.func_145831_w().field_73011_w.field_76574_g, coord);
    }

    public static List updateItemSearch(ComponentMenuItem menu, String search, boolean showAll) {
        ScrollController searchController = ComponentHelper.getController((ComponentMenuStuff)menu);
        Thread thread = new Thread(new SearchItems(search, searchController, showAll));
        thread.start();
        return searchController.getResult();
    }

    public static boolean containerAdvancedSearch(ConnectionBlock block, String search) {
        TileEntity tileEntity = block.getTileEntity();
        String toSearch = StevesHooks.getLabel(tileEntity);
        Pattern pattern = Pattern.compile(Pattern.quote(search), 2);
        return toSearch != null && pattern.matcher(toSearch).find() || pattern.matcher(StevesHooks.getContentString(tileEntity)).find();
    }

    public static void registerTicker(FlowComponent component, ComponentMenuTriggered menu) {
        if (!StevesHooks.getRegistry(menu).containsEntry((Object)component.getManager(), (Object)component)) {
            StevesHooks.getRegistry(menu).put((Object)component.getManager(), (Object)component);
        }
    }

    public static TileEntityManager tickTriggers(TileEntityManager manager) {
        StevesHooks.tick(delayedRegistry.get((Object)manager));
        return manager;
    }

    private static void tick(Collection<FlowComponent> triggers) {
        if (triggers != null) {
            Iterator<FlowComponent> itr = triggers.iterator();
            while (itr.hasNext()) {
                ComponentMenuTriggered toTrigger = (ComponentMenuTriggered)((Object)itr.next().getMenus().get(6));
                if (toTrigger.isVisible()) {
                    toTrigger.tick();
                    if (!toTrigger.remove()) continue;
                    itr.remove();
                    continue;
                }
                itr.remove();
            }
        }
    }

    private static Multimap<TileEntityManager, FlowComponent> getRegistry(ComponentMenuTriggered menu) {
        return delayedRegistry;
    }
}

