/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.nutrients;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class NutrientUtils {
    public static List<Nutrient> getFoodNutrients(ItemStack eatingFood) {
        ArrayList<Nutrient> nutrientsFound = new ArrayList<Nutrient>();
        block0: for (Nutrient nutrient : NutrientList.get()) {
            for (ItemStack listedFood : nutrient.foodItems) {
                if (!listedFood.func_77969_a(eatingFood)) continue;
                nutrientsFound.add(nutrient);
                continue block0;
            }
            for (String listedOreDict : nutrient.foodOreDict) {
                for (ItemStack itemStack : OreDictionary.getOres((String)listedOreDict)) {
                    if (!itemStack.func_77969_a(eatingFood)) continue;
                    nutrientsFound.add(nutrient);
                    continue block0;
                }
            }
        }
        return nutrientsFound;
    }

    public static float calculateNutrition(FoodValues foodValues, List<Nutrient> nutrients) {
        return NutrientUtils.getNutrientValue(foodValues.hunger, nutrients.size());
    }

    public static float getNutrientValue(int hungerValue, int numNutrients) {
        float adjustedFoodValue = (float)((double)hungerValue * 0.5);
        float lossPercentage = (float)Config.lossPerNutrient / 100.0f;
        float foodLoss = (adjustedFoodValue *= Config.nutritionMultiplier) * lossPercentage * (float)(numNutrients - 1);
        return Math.max(0.0f, adjustedFoodValue - foodLoss);
    }

    public static void findRegisteredFoods() {
        for (Object object : Item.field_150901_e) {
            Item item = (Item)object;
            ItemStack itemStack = new ItemStack(item);
            if (!AppleCoreAPI.accessor.isFood(itemStack) || NutrientUtils.getFoodNutrients(itemStack).size() != 0) continue;
            Log.warn("Registered food without nutrients: " + item.func_77658_a());
        }
    }
}

