/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.renderers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import tuhljin.automagy.blocks.BlockHourglassMagic;
import tuhljin.automagy.tiles.TileEntityHourglass;

public class BlockHourglassRenderer
extends TileEntitySpecialRenderer {
    public static final String OBJ_MODEL = "textures/models/hourglass.obj";
    public static final String TEXTURE_STANDARD = "textures/models/hourglass.png";
    public static final String TEXTURE_MAGIC = "textures/models/hourglass-gold.png";
    public static final String TEXTURE_GLASS = "textures/models/hourglass-glass.png";
    public static final String TEXTURE_SAND = "textures/models/hourglass-sand.png";
    public static final String TEXTURE_REDSTONE = "textures/models/hourglass-redstone.png";
    protected final IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("Automagy".toLowerCase(), "textures/models/hourglass.obj"));

    public void func_147500_a(TileEntity te, double x, double y, double z, float scale) {
        TileEntityHourglass teh = (TileEntityHourglass)te;
        boolean isMagic = te.func_145838_q() instanceof BlockHourglassMagic;
        String texture = isMagic ? TEXTURE_MAGIC : TEXTURE_STANDARD;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.2), (double)(z + 0.5));
        GL11.glScaled((double)0.2, (double)0.2, (double)0.2);
        switch (te.func_145832_p()) {
            case 0: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), texture));
        this.model.renderOnly(new String[]{"Right_Pillar_group", "group_Bottom", "group_Left_Pillar", "group_Top"});
        if (!isMagic) {
            this.model.renderOnly(new String[]{"group_Left_Turner", "group_Right_Turner"});
        } else {
            if (teh.getRedstoneSignalStrength() > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
            } else {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.9f);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_REDSTONE));
            this.model.renderOnly(new String[]{"group_Redstone"});
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        long time = System.nanoTime();
        float rotation = (float)(time - teh.timeDidFlip) / 1.0E9f / teh.SECONDS_COOLDOWN_BETWEEN_FLIPS;
        if ((double)rotation < 1.0) {
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(180.0 * (double)rotation), (double)0.0, (double)0.0, (double)1.0);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_SAND));
        this.renderSandState(teh, (double)rotation < 1.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_GLASS));
        this.model.renderOnly(new String[]{"Group_glass"});
        GL11.glPopMatrix();
    }

    private void renderSandState(TileEntityHourglass teh, boolean rotating) {
        float sectionSize;
        float percent = teh.percentageComplete();
        if (percent <= (sectionSize = 16.666666f)) {
            this.model.renderOnly(new String[]{"sandtop1"});
            if (!rotating) {
                this.model.renderOnly(new String[]{"sandbtm6"});
            }
        } else if (percent <= sectionSize * 2.0f) {
            this.model.renderOnly(new String[]{"sandtop2"});
            this.model.renderOnly(new String[]{"sandbtm5"});
        } else if (percent <= sectionSize * 3.0f) {
            this.model.renderOnly(new String[]{"sandtop3"});
            this.model.renderOnly(new String[]{"sandbtm4"});
        } else if (percent <= sectionSize * 4.0f) {
            this.model.renderOnly(new String[]{"sandtop4"});
            this.model.renderOnly(new String[]{"sandbtm3"});
        } else if (percent <= sectionSize * 5.0f) {
            this.model.renderOnly(new String[]{"sandtop5"});
            this.model.renderOnly(new String[]{"sandbtm2"});
        } else if (percent < 100.0f) {
            this.model.renderOnly(new String[]{"sandtop6"});
            this.model.renderOnly(new String[]{"sandbtm1"});
        } else {
            this.model.renderOnly(new String[]{"sandbtm0"});
        }
    }
}

