/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TriggerFluidContainerLevel
extends BCStatement
implements ITriggerExternal {
    public TriggerType type;

    public TriggerFluidContainerLevel(TriggerType type) {
        super("buildcraft:fluid." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.fluid." + type.name().toLowerCase(Locale.ENGLISH));
        this.type = type;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.fluidlevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer statementContainer, IStatementParameter[] parameters) {
        if (tile instanceof IFluidHandler) {
            FluidTankInfo[] liquids;
            IFluidHandler container = (IFluidHandler)tile;
            FluidStack searchedFluid = null;
            if (parameters != null && parameters.length >= 1 && parameters[0] != null && parameters[0].getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameters[0].getItemStack());
            }
            if (searchedFluid != null) {
                searchedFluid.amount = 1;
            }
            if ((liquids = container.getTankInfo(side)) == null || liquids.length == 0) {
                return false;
            }
            for (FluidTankInfo c : liquids) {
                if (c == null) continue;
                if (c.fluid == null) {
                    if (searchedFluid == null) {
                        return true;
                    }
                    return container.fill(side, searchedFluid, false) > 0;
                }
                if (searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                float percentage = (float)c.fluid.amount / (float)c.capacity;
                return percentage < this.type.level;
            }
        }
        return false;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraftcore:triggers/trigger_liquidcontainer_" + this.type.name().toLowerCase());
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static enum TriggerType {
        BELOW25(0.25f),
        BELOW50(0.5f),
        BELOW75(0.75f);

        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }
    }
}

