/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import twilightforest.TwilightForestMod;
import twilightforest.inventory.InventoryTFGoblinInput;
import twilightforest.inventory.InventoryTFGoblinUncrafting;
import twilightforest.inventory.SlotTFGoblinAssembly;
import twilightforest.inventory.SlotTFGoblinCraftResult;
import twilightforest.inventory.SlotTFGoblinUncrafting;

public class ContainerTFUncrafting
extends Container {
    public InventoryTFGoblinUncrafting uncraftingMatrix = new InventoryTFGoblinUncrafting(this);
    public InventoryCrafting assemblyMatrix = new InventoryCrafting((Container)this, 3, 3);
    public InventoryCrafting combineMatrix = new InventoryCrafting((Container)this, 3, 3);
    public IInventory tinkerInput = new InventoryTFGoblinInput(this);
    public IInventory tinkerResult = new InventoryCraftResult();
    private World worldObj;

    public ContainerTFUncrafting(InventoryPlayer inventory, World world, int x, int y, int z) {
        int invY;
        int invX;
        this.worldObj = world;
        this.func_75146_a(new Slot(this.tinkerInput, 0, 13, 35));
        this.func_75146_a((Slot)new SlotTFGoblinCraftResult(inventory.field_70458_d, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.func_75146_a(new SlotTFGoblinUncrafting(inventory.field_70458_d, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.func_75146_a(new SlotTFGoblinAssembly(inventory.field_70458_d, this.tinkerInput, (IInventory)this.assemblyMatrix, this.uncraftingMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.func_75146_a(new Slot((IInventory)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.func_75146_a(new Slot((IInventory)inventory, invX, 8 + invX * 18, 142));
        }
        this.func_75130_a((IInventory)this.assemblyMatrix);
    }

    public void func_75130_a(IInventory par1IInventory) {
        if (par1IInventory == this.tinkerInput) {
            ItemStack inputStack = this.tinkerInput.func_70301_a(0);
            IRecipe recipe = this.getRecipeFor(inputStack);
            if (recipe != null) {
                int i;
                int recipeWidth = this.getRecipeWidth(recipe);
                int recipeHeight = this.getRecipeHeight(recipe);
                ItemStack[] recipeItems = this.getRecipeItems(recipe);
                for (i = 0; i < this.uncraftingMatrix.func_70302_i_(); ++i) {
                    this.uncraftingMatrix.func_70299_a(i, null);
                }
                for (int invY = 0; invY < recipeHeight; ++invY) {
                    for (int invX = 0; invX < recipeWidth; ++invX) {
                        ItemStack ingredient = ItemStack.func_77944_b((ItemStack)recipeItems[invX + invY * recipeWidth]);
                        if (ingredient != null && ingredient.field_77994_a > 1) {
                            ingredient.field_77994_a = 1;
                        }
                        if (ingredient != null && (ingredient.func_77952_i() == -1 || ingredient.func_77952_i() == Short.MAX_VALUE)) {
                            ingredient.func_77964_b(0);
                        }
                        this.uncraftingMatrix.func_70299_a(invX + invY * 3, ingredient);
                    }
                }
                if (inputStack.func_77951_h()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (int i2 = 0; i2 < 9 && damagedParts > 0; ++i2) {
                        if (!this.isDamageableComponent(this.uncraftingMatrix.func_70301_a(i2))) continue;
                        this.uncraftingMatrix.func_70301_a((int)i2).field_77994_a = 0;
                        --damagedParts;
                    }
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.uncraftingMatrix.func_70301_a(i);
                    if (!this.isIngredientProblematic(ingredient)) continue;
                    ingredient.field_77994_a = 0;
                }
                this.uncraftingMatrix.numberOfInputItems = recipe.func_77571_b().field_77994_a;
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                for (int i = 0; i < 9; ++i) {
                    this.uncraftingMatrix.func_70299_a(i, null);
                }
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (par1IInventory == this.assemblyMatrix || par1IInventory == this.tinkerInput) {
            if (this.isMatrixEmpty(this.tinkerInput)) {
                this.tinkerResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.assemblyMatrix, this.worldObj));
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.tinkerResult.func_70299_a(0, null);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            }
        }
        if (par1IInventory != this.combineMatrix && !this.isMatrixEmpty(this.uncraftingMatrix) && !this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            for (int i = 0; i < 9; ++i) {
                if (this.assemblyMatrix.func_70301_a(i) != null) {
                    this.combineMatrix.func_70299_a(i, this.assemblyMatrix.func_70301_a(i));
                    continue;
                }
                if (this.uncraftingMatrix.func_70301_a(i) != null && this.uncraftingMatrix.func_70301_a((int)i).field_77994_a > 0) {
                    this.combineMatrix.func_70299_a(i, this.uncraftingMatrix.func_70301_a(i));
                    continue;
                }
                this.combineMatrix.func_70299_a(i, null);
            }
            ItemStack result = CraftingManager.func_77594_a().func_82787_a(this.combineMatrix, this.worldObj);
            ItemStack input = this.tinkerInput.func_70301_a(0);
            if (result != null && this.isValidMatchForInput(input, result)) {
                NBTTagCompound inputTags = input.func_77978_p();
                if (inputTags != null) {
                    inputTags = (NBTTagCompound)inputTags.func_74737_b();
                }
                Map resultInnateEnchantments = null;
                if (result.func_77948_v()) {
                    resultInnateEnchantments = EnchantmentHelper.func_82781_a((ItemStack)result);
                }
                Map inputEnchantments = null;
                if (input.func_77948_v()) {
                    inputEnchantments = EnchantmentHelper.func_82781_a((ItemStack)input);
                    for (Integer key : inputEnchantments.keySet()) {
                        int enchID = key;
                        Enchantment ench = Enchantment.field_77331_b[enchID];
                        if (ench.func_92089_a(result)) continue;
                        inputEnchantments.remove(key);
                    }
                }
                if (inputTags != null) {
                    inputTags.func_82580_o("ench");
                    result.func_77982_d((NBTTagCompound)inputTags.func_74737_b());
                    if (inputEnchantments != null) {
                        EnchantmentHelper.func_82782_a((Map)inputEnchantments, (ItemStack)result);
                    }
                }
                this.tinkerResult.func_70299_a(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
                if (this.uncraftingMatrix.recraftingCost > 0 && !result.func_82837_s()) {
                    result.func_82841_c(input.func_82838_A() + 2);
                }
                if (resultInnateEnchantments != null && resultInnateEnchantments.size() > 0) {
                    for (Object key : resultInnateEnchantments.keySet()) {
                        int enchID = (Integer)key;
                        int level = (Integer)resultInnateEnchantments.get(key);
                        Enchantment ench = Enchantment.field_77331_b[enchID];
                        if (EnchantmentHelper.func_77506_a((int)enchID, (ItemStack)result) > level) {
                            level = EnchantmentHelper.func_77506_a((int)enchID, (ItemStack)result);
                        }
                        if (EnchantmentHelper.func_77506_a((int)enchID, (ItemStack)result) >= level) continue;
                        result.func_77966_a(ench, level);
                    }
                }
            }
        }
    }

    protected boolean isIngredientProblematic(ItemStack ingredient) {
        return ingredient != null && (ingredient.func_77973_b().hasContainerItem(ingredient) || ingredient.func_77977_a().contains("itemMatter"));
    }

    public IRecipe getRecipeFor(ItemStack inputStack) {
        if (inputStack != null) {
            for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || recipe.func_77571_b().func_77973_b() != inputStack.func_77973_b() || inputStack.field_77994_a < recipe.func_77571_b().field_77994_a || recipe.func_77571_b().func_77981_g() && recipe.func_77571_b().func_77960_j() != inputStack.func_77960_j()) continue;
                return recipe;
            }
        }
        return null;
    }

    public boolean isValidMatchForInput(ItemStack inputStack, ItemStack resultStack) {
        if (inputStack.func_77973_b() instanceof ItemPickaxe && resultStack.func_77973_b() instanceof ItemPickaxe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemAxe && resultStack.func_77973_b() instanceof ItemAxe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemSpade && resultStack.func_77973_b() instanceof ItemSpade) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemHoe && resultStack.func_77973_b() instanceof ItemHoe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemSword && resultStack.func_77973_b() instanceof ItemSword) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemBow && resultStack.func_77973_b() instanceof ItemBow) {
            return true;
        }
        Item item = inputStack.func_77973_b();
        if (item instanceof ItemArmor) {
            ItemArmor inputArmor = (ItemArmor)item;
            item = resultStack.func_77973_b();
            if (item instanceof ItemArmor) {
                ItemArmor resultArmor = (ItemArmor)item;
                return inputArmor.field_77881_a == resultArmor.field_77881_a;
            }
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    public int calculateUncraftingCost() {
        if (!this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            return 0;
        }
        return this.countDamageableParts(this.uncraftingMatrix);
    }

    public int calculateRecraftingCost() {
        if (this.tinkerInput.func_70301_a(0) == null || !this.tinkerInput.func_70301_a(0).func_77948_v() || this.tinkerResult.func_70301_a(0) == null) {
            return 0;
        }
        ItemStack input = this.tinkerInput.func_70301_a(0);
        ItemStack output = this.tinkerResult.func_70301_a(0);
        int cost = 0;
        cost += input.func_82838_A();
        int enchantCost = this.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * EnchantmentHelper.func_82781_a((ItemStack)output).size();
        cost += damagedCost;
        int enchantabilityDifference = input.func_77973_b().func_77619_b() - output.func_77973_b().func_77619_b();
        cost += enchantabilityDifference;
        cost = Math.max(1, cost);
        return cost;
    }

    public int countHighestEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : Enchantment.field_77331_b) {
            int level;
            if (ench == null || (level = EnchantmentHelper.func_77506_a((int)ench.field_77352_x, (ItemStack)itemStack)) <= count) continue;
            count += this.getWeightModifier(ench) * level;
        }
        return count;
    }

    public int countTotalEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : Enchantment.field_77331_b) {
            int level;
            if (ench == null || (level = EnchantmentHelper.func_77506_a((int)ench.field_77352_x, (ItemStack)itemStack)) <= 0) continue;
            count += this.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    public int getWeightModifier(Enchantment ench) {
        int n;
        switch (ench.func_77324_c()) {
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int shiftHeld, EntityPlayer par4EntityPlayer) {
        if (slotNum > 0 && par4EntityPlayer.field_71071_by.func_70445_o() == null && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.assemblyMatrix && !((Slot)this.field_75151_b.get(slotNum)).func_75216_d() && this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.tinkerResult && this.calculateRecraftingCost() > par4EntityPlayer.field_71068_ca && !par4EntityPlayer.field_71075_bZ.field_75098_d) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && this.calculateUncraftingCost() > par4EntityPlayer.field_71068_ca && !par4EntityPlayer.field_71075_bZ.field_75098_d) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && TwilightForestMod.disableUncrafting) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && (((Slot)this.field_75151_b.get(slotNum)).func_75211_c() == null || ((Slot)this.field_75151_b.get((int)slotNum)).func_75211_c().field_77994_a == 0)) {
            return null;
        }
        ItemStack ret = super.func_75144_a(slotNum, mouseButton, shiftHeld, par4EntityPlayer);
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c instanceof InventoryTFGoblinInput) {
            this.func_75130_a(this.tinkerInput);
        }
        return ret;
    }

    protected void func_75133_b(int slotNum, int mouseButton, boolean par3, EntityPlayer par4EntityPlayer) {
        if (((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix) {
            slotNum += 9;
        }
        this.func_75144_a(slotNum, mouseButton, 1, par4EntityPlayer);
    }

    private boolean isMatrixEmpty(IInventory matrix) {
        boolean matrixEmpty = true;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            if (matrix.func_70301_a(i) == null) continue;
            matrixEmpty = false;
        }
        return matrixEmpty;
    }

    public boolean isDamageableComponent(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != Items.field_151055_y;
    }

    public int countDamageableParts(IInventory matrix) {
        int count = 0;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            if (!this.isDamageableComponent(matrix.func_70301_a(i))) continue;
            ++count;
        }
        return count;
    }

    public int countDamagedParts(ItemStack input) {
        int totalMax4 = Math.max(4, this.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.func_77960_j() / (float)input.func_77958_k();
        int damagedParts = (int)Math.ceil((float)totalMax4 * damage);
        return damagedParts;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        ItemStack copyItem = null;
        Slot transferSlot = (Slot)this.field_75151_b.get(slotNum);
        if (transferSlot != null && transferSlot.func_75216_d()) {
            ItemStack transferStack = transferSlot.func_75211_c();
            copyItem = transferStack.func_77946_l();
            if (slotNum == 0 || slotNum == 1) {
                if (!this.func_75135_a(transferStack, 20, 56, true)) {
                    return null;
                }
                transferSlot.func_75220_a(transferStack, copyItem);
            } else if (slotNum >= 20 && slotNum < 47 ? !this.func_75135_a(transferStack, 47, 56, false) : (slotNum >= 47 && slotNum < 56 ? !this.func_75135_a(transferStack, 20, 47, false) : !this.func_75135_a(transferStack, 20, 56, false))) {
                return null;
            }
            if (transferStack.field_77994_a == 0) {
                transferSlot.func_75215_d(null);
            } else {
                transferSlot.func_75218_e();
            }
            if (transferStack.field_77994_a == copyItem.field_77994_a) {
                return null;
            }
            transferSlot.func_82870_a(player, transferStack);
        }
        return copyItem;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (!this.worldObj.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack assemblyStack = this.assemblyMatrix.func_70304_b(i);
                if (assemblyStack == null) continue;
                par1EntityPlayer.func_71019_a(assemblyStack, false);
            }
            ItemStack inputStack = this.tinkerInput.func_70304_b(0);
            if (inputStack != null) {
                par1EntityPlayer.func_71019_a(inputStack, false);
            }
        }
    }

    public ItemStack[] getRecipeItems(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeItemsShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeItemsOre((ShapedOreRecipe)recipe);
        }
        return null;
    }

    public ItemStack[] getRecipeItemsShaped(ShapedRecipes shaped) {
        return shaped.field_77574_d;
    }

    public ItemStack[] getRecipeItemsOre(ShapedOreRecipe shaped) {
        try {
            Object[] objects = (Object[])ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)3);
            ItemStack[] items = new ItemStack[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof ItemStack) {
                    items[i] = (ItemStack)objects[i];
                }
                if (!(objects[i] instanceof ArrayList) || ((ArrayList)objects[i]).size() <= 0) continue;
                items[i] = (ItemStack)((ArrayList)objects[i]).get(0);
            }
            return items;
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getRecipeWidth(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeWidthShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeWidthOre((ShapedOreRecipe)recipe);
        }
        return -1;
    }

    public int getRecipeWidthShaped(ShapedRecipes shaped) {
        return shaped.field_77576_b;
    }

    public int getRecipeWidthOre(ShapedOreRecipe shaped) {
        try {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)4);
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getRecipeHeight(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeHeightShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeHeightOre((ShapedOreRecipe)recipe);
        }
        return -1;
    }

    public int getRecipeHeightShaped(ShapedRecipes shaped) {
        return shaped.field_77577_c;
    }

    public int getRecipeHeightOre(ShapedOreRecipe shaped) {
        try {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)5);
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }
}

