/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.math;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Objects;

public class Size {
    public static final Size ZERO = Size.zero();
    public final int width;
    public final int height;

    public static Size zero() {
        return new Size(0, 0);
    }

    public Size(int width, int height) {
        this.width = Math.max(0, width);
        this.height = Math.max(0, height);
    }

    public Size(double width, double height) {
        this((int)width, (int)height);
    }

    public Size(Size widthComponent, Size heightComponent) {
        this(widthComponent.width, heightComponent.height);
    }

    public Size(int width, Size heightComponent) {
        this(width, heightComponent.height);
    }

    public Size(Size widthComponent, int height) {
        this(widthComponent.width, height);
    }

    public static Size ofDimension(Dimension dimension) {
        return new Size(dimension.width, dimension.height);
    }

    public boolean isLargerThan(Size size) {
        return size.width * size.height < this.width * this.height;
    }

    public boolean hasLargerDimensionsThan(Size size) {
        return this.width > size.width && this.height > size.height;
    }

    public Size shrink(int width, int height) {
        return new Size(this.width - width, this.height - height);
    }

    public Size grow(int width, int height) {
        return new Size(this.width + width, this.height + height);
    }

    public Size scale(float widthScale, float heightScale) {
        return new Size((float)this.width * widthScale, (float)this.height * heightScale);
    }

    public Size scale(float scale) {
        return this.scale(scale, scale);
    }

    public boolean isZero() {
        return this.width == 0 && this.height == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        return Float.compare(size.width, this.width) == 0 && Float.compare(size.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }

    public String toString() {
        return "[" + this.width + ", " + this.height + "]";
    }

    public Dimension asDimension() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle asRectangle() {
        return new Rectangle(this.width, this.height);
    }

    public static Size ofJson(JsonElement jsonElement) {
        int width = 0;
        int height = 0;
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            width = JsonHelper.getInt(json, 0, "width", "w");
            height = JsonHelper.getInt(json, 0, "height", "h");
        } else {
            String raw = jsonElement.getAsString();
            if (raw.contains(",")) {
                String[] parts = raw.split(",");
                try {
                    if (!parts[0].isEmpty()) {
                        width = Integer.parseInt(parts[0]);
                    }
                    if (parts.length > 1 && !parts[1].isEmpty()) {
                        height = Integer.parseInt(parts[1]);
                    }
                }
                catch (NumberFormatException e) {
                    ModularUI.logger.error("Error parsing JSON pos: {}", new Object[]{raw});
                    e.printStackTrace();
                }
            }
        }
        return new Size(width, height);
    }
}

