/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import com.brandon3055.draconicevolution.integration.computers.cc.CCAdapter;
import com.brandon3055.draconicevolution.integration.computers.oc.DEManagedPeripheral;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CCOCIntegration {
    public static void init() {
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            CCOCIntegration.initCC();
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            CCOCIntegration.initOC();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public static void initCC() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new DEPeripheralProvider());
    }

    @Optional.Method(modid="OpenComputers")
    public static void initOC() {
        Driver.add((Block)new OCAdapter());
    }

    public static class DEPeripheralProvider
    implements IPeripheralProvider {
        public IPeripheral getPeripheral(World world, int x, int y, int z, int i3) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IDEPeripheral) {
                return new CCAdapter((IDEPeripheral)tile);
            }
            return null;
        }
    }

    public static class OCAdapter
    extends DriverTileEntity {
        public Class<?> getTileEntityClass() {
            return IDEPeripheral.class;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
            return new DEManagedPeripheral((IDEPeripheral)world.func_147438_o(x, y, z));
        }
    }
}

