/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.InvisibleMultiblock;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyStorageCore
extends TileObjectSync {
    public static final int STABILIZER_SEARCH_DISTANCE = 11;
    protected MultiblockHelper.TileLocation[] stabilizers = new MultiblockHelper.TileLocation[4];
    protected int tier = 0;
    protected boolean online = false;
    public float modelRotation = 0.0f;
    private long energy = 0L;
    private long capacity = 0L;
    private long lastTickCapacity = 0L;

    public TileEnergyStorageCore() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            this.stabilizers[i] = new MultiblockHelper.TileLocation();
        }
    }

    public void func_145845_h() {
        if (!this.online) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.modelRotation = (float)((double)this.modelRotation + 0.5);
            return;
        }
        this.detectAndSendChanges();
    }

    public boolean tryActivate(boolean isCreativeMode) {
        boolean isStructureValid;
        if (!this.findStabilizers()) {
            return false;
        }
        if (!this.setTier()) {
            return false;
        }
        this.online = false;
        boolean bl = isStructureValid = isCreativeMode ? this.scanStructure(this::setInnerBlock, this::setOuterBlock) : this.scanStructure(this::isInnerBlock, this::isOuterBlock);
        if (isStructureValid) {
            if (this.scanStructure(this::activateInnerBlock, this::activateOuterBlock)) {
                this.online = true;
                this.activateStabilizers();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            this.deactivateStabilizers();
        }
        return false;
    }

    public void validateStructure(boolean update) {
        this.online = this.areStabilizersActive() && this.scanStructure(this::isInnerBlock, this::isOuterBlock);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.online) {
            this.deactivateStabilizers();
            if (update) {
                this.reIntegrate();
            }
        }
    }

    private void reIntegrate() {
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.invisibleMultiblock) continue;
                    InvisibleMultiblock.revertStructure(this.field_145850_b, x, y, z);
                }
            }
        }
    }

    private boolean findStabilizers() {
        ForgeDirection[] horizontalDirections = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH};
        int stabilizersCount = 0;
        block0: for (ForgeDirection direction : horizontalDirections) {
            for (int distance = 1; distance <= 11; ++distance) {
                int x = this.field_145851_c + direction.offsetX * distance;
                int z = this.field_145849_e + direction.offsetZ * distance;
                if (this.field_145850_b.func_147439_a(x, this.field_145848_d, z) != ModBlocks.particleGenerator) continue;
                if (this.field_145850_b.func_72805_g(x, this.field_145848_d, z) == 1) {
                    return false;
                }
                this.stabilizers[stabilizersCount++] = new MultiblockHelper.TileLocation(x, this.field_145848_d, z);
                continue block0;
            }
        }
        return stabilizersCount == 4;
    }

    private boolean setTier() {
        int range = 5;
        int[] outerBlocksDistances = new int[6];
        block0: for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (int distance = 1; distance <= 5; ++distance) {
                int x = this.field_145851_c + direction.offsetX * distance;
                int y = this.field_145848_d + direction.offsetY * distance;
                int z = this.field_145849_e + direction.offsetZ * distance;
                if (!this.isOuterBlock(x, y, z)) continue;
                outerBlocksDistances[direction.ordinal()] = distance;
                continue block0;
            }
        }
        for (int i = 1; i < outerBlocksDistances.length; ++i) {
            if (outerBlocksDistances[i] == outerBlocksDistances[0]) continue;
            return false;
        }
        this.tier = outerBlocksDistances[0];
        if (this.tier > 1) {
            ++this.tier;
        }
        if (this.tier == 1 && this.isOuterBlock(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e)) {
            this.tier = 2;
        }
        return true;
    }

    private boolean scanStructure(IBlockAction innerBlock, IBlockAction outerBlock) {
        boolean bl;
        IBlockAction isReplaceable = this::isReplaceable;
        switch (this.tier) {
            case 0: {
                bl = this.scanCube(isReplaceable, 1);
                break;
            }
            case 1: {
                if (this.scanRings(isReplaceable, 1, 1) && this.scanSides(outerBlock, 0, 1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = this.scanCube(outerBlock, 1);
                break;
            }
            case 3: {
                if (this.scanCube(innerBlock, 1) && this.scanSides(outerBlock, 1, 2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if (this.scanCube(innerBlock, 1) && this.scanSides(innerBlock, 1, 2) && this.scanSides(outerBlock, 1, 3) && this.scanRings(outerBlock, 2, 2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if (this.scanCube(innerBlock, 2) && this.scanSides(innerBlock, 1, 3) && this.scanSides(outerBlock, 1, 4) && this.scanRings(outerBlock, 2, 3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if (this.scanCube(innerBlock, 2) && this.scanSides(innerBlock, 2, 3) && this.scanSides(innerBlock, 1, 4) && this.scanSides(outerBlock, 1, 5) && this.scanRings(outerBlock, 2, 4) && this.scanRings(outerBlock, 3, 3)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean scanCube(IBlockAction action, int size) {
        for (int x = this.field_145851_c - size; x <= this.field_145851_c + size; ++x) {
            for (int y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
                for (int z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                    if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || action.process(x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean scanRings(IBlockAction action, int radius, int distance) {
        boolean isSuccessful;
        boolean isAsymmetric = radius != distance;
        for (int x = this.field_145851_c - radius; x <= this.field_145851_c + radius; ++x) {
            boolean bl = isSuccessful = action.process(x, this.field_145848_d - radius, this.field_145849_e - distance) && action.process(x, this.field_145848_d - radius, this.field_145849_e + distance) && action.process(x, this.field_145848_d + radius, this.field_145849_e - distance) && action.process(x, this.field_145848_d + radius, this.field_145849_e + distance);
            if (isSuccessful && isAsymmetric) {
                boolean bl2 = isSuccessful = action.process(x, this.field_145848_d - distance, this.field_145849_e - radius) && action.process(x, this.field_145848_d - distance, this.field_145849_e + radius) && action.process(x, this.field_145848_d + distance, this.field_145849_e - radius) && action.process(x, this.field_145848_d + distance, this.field_145849_e + radius);
            }
            if (isSuccessful) continue;
            return false;
        }
        for (int y = this.field_145848_d - radius; y <= this.field_145848_d + radius; ++y) {
            boolean bl = isSuccessful = action.process(this.field_145851_c - radius, y, this.field_145849_e - distance) && action.process(this.field_145851_c - radius, y, this.field_145849_e + distance) && action.process(this.field_145851_c + radius, y, this.field_145849_e - distance) && action.process(this.field_145851_c + radius, y, this.field_145849_e + distance);
            if (isSuccessful && isAsymmetric) {
                boolean bl3 = isSuccessful = action.process(this.field_145851_c - distance, y, this.field_145849_e - radius) && action.process(this.field_145851_c - distance, y, this.field_145849_e + radius) && action.process(this.field_145851_c + distance, y, this.field_145849_e - radius) && action.process(this.field_145851_c + distance, y, this.field_145849_e + radius);
            }
            if (isSuccessful) continue;
            return false;
        }
        for (int z = this.field_145849_e - radius; z <= this.field_145849_e + radius; ++z) {
            boolean bl = isSuccessful = action.process(this.field_145851_c - radius, this.field_145848_d - distance, z) && action.process(this.field_145851_c - radius, this.field_145848_d + distance, z) && action.process(this.field_145851_c + radius, this.field_145848_d - distance, z) && action.process(this.field_145851_c + radius, this.field_145848_d + distance, z);
            if (isSuccessful && isAsymmetric) {
                boolean bl4 = isSuccessful = action.process(this.field_145851_c - distance, this.field_145848_d - radius, z) && action.process(this.field_145851_c - distance, this.field_145848_d + radius, z) && action.process(this.field_145851_c + distance, this.field_145848_d - radius, z) && action.process(this.field_145851_c + distance, this.field_145848_d + radius, z);
            }
            if (isSuccessful) continue;
            return false;
        }
        return true;
    }

    private boolean scanSides(IBlockAction action, int size, int distance) {
        int z;
        boolean isSuccessful;
        int x;
        for (x = this.field_145851_c - size; x <= this.field_145851_c + size; ++x) {
            for (int y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
                boolean bl = isSuccessful = action.process(x, y, this.field_145849_e - distance) && action.process(x, y, this.field_145849_e + distance);
                if (isSuccessful) continue;
                return false;
            }
        }
        for (x = this.field_145851_c - size; x <= this.field_145851_c + size; ++x) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                boolean bl = isSuccessful = action.process(x, this.field_145848_d - distance, z) && action.process(x, this.field_145848_d + distance, z);
                if (isSuccessful) continue;
                return false;
            }
        }
        for (int y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                boolean bl = isSuccessful = action.process(this.field_145851_c - distance, y, z) && action.process(this.field_145851_c + distance, y, z);
                if (isSuccessful) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReplaceable(int x, int y, int z) {
        return this.field_145850_b.func_147437_c(x, y, z) || this.field_145850_b.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_145850_b, x, y, z);
    }

    private boolean isInnerBlock(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        int metadata = this.field_145850_b.func_72805_g(x, y, z);
        return block == BalanceConfigHandler.energyStorageStructureBlock && metadata == BalanceConfigHandler.energyStorageStructureBlockMetadata || block == ModBlocks.invisibleMultiblock && metadata == 1;
    }

    private boolean activateInnerBlock(int x, int y, int z) {
        this.field_145850_b.func_147465_d(x, y, z, (Block)ModBlocks.invisibleMultiblock, 1, 2);
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof TileInvisibleMultiblock) {
            TileInvisibleMultiblock multiblock = (TileInvisibleMultiblock)tile;
            multiblock.master = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        LogHelper.error("Failed to activate structure (activateRedstone)");
        return false;
    }

    private boolean setInnerBlock(int x, int y, int z) {
        this.field_145850_b.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureBlock, BalanceConfigHandler.energyStorageStructureBlockMetadata, 3);
        return true;
    }

    private boolean isOuterBlock(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        int metadata = this.field_145850_b.func_72805_g(x, y, z);
        return block == BalanceConfigHandler.energyStorageStructureOuterBlock && metadata == BalanceConfigHandler.energyStorageStructureOuterBlockMetadata || block == ModBlocks.invisibleMultiblock && metadata == 0;
    }

    private boolean activateOuterBlock(int x, int y, int z) {
        this.field_145850_b.func_147465_d(x, y, z, (Block)ModBlocks.invisibleMultiblock, 0, 2);
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof TileInvisibleMultiblock) {
            TileInvisibleMultiblock multiblock = (TileInvisibleMultiblock)tile;
            multiblock.master = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        LogHelper.error("Failed to activate structure (activateDraconium)");
        return false;
    }

    private boolean setOuterBlock(int x, int y, int z) {
        this.field_145850_b.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureOuterBlock, BalanceConfigHandler.energyStorageStructureOuterBlockMetadata, 3);
        return true;
    }

    public boolean isOnline() {
        return this.online;
    }

    private void activateStabilizers() {
        for (MultiblockHelper.TileLocation stabilizer : this.stabilizers) {
            TileEntity tile = stabilizer.getTileEntity(this.field_145850_b);
            if (!(tile instanceof TileParticleGenerator)) {
                LogHelper.error("Missing Tile Entity (Particle Generator)");
                return;
            }
            TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
            particleGenerator.isInStabilizerMode = true;
            particleGenerator.setMaster(new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_72921_c(stabilizer.getXCoord(), stabilizer.getYCoord(), stabilizer.getZCoord(), 1, 2);
        }
        this.initializeCapacity();
    }

    private void initializeCapacity() {
        long capacity;
        long l;
        switch (this.tier) {
            case 0: {
                l = BalanceConfigHandler.energyStorageTier1Storage;
                break;
            }
            case 1: {
                l = BalanceConfigHandler.energyStorageTier2Storage;
                break;
            }
            case 2: {
                l = BalanceConfigHandler.energyStorageTier3Storage;
                break;
            }
            case 3: {
                l = BalanceConfigHandler.energyStorageTier4Storage;
                break;
            }
            case 4: {
                l = BalanceConfigHandler.energyStorageTier5Storage;
                break;
            }
            case 5: {
                l = BalanceConfigHandler.energyStorageTier6Storage;
                break;
            }
            case 6: {
                l = BalanceConfigHandler.energyStorageTier7Storage;
                break;
            }
            default: {
                l = 0L;
            }
        }
        this.capacity = capacity = l;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void deactivateStabilizers() {
        for (MultiblockHelper.TileLocation stabilizer : this.stabilizers) {
            TileEntity tile = stabilizer.getTileEntity(this.field_145850_b);
            if (!(tile instanceof TileParticleGenerator)) continue;
            TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
            particleGenerator.isInStabilizerMode = false;
            this.field_145850_b.func_72921_c(stabilizer.getXCoord(), stabilizer.getYCoord(), stabilizer.getZCoord(), 0, 2);
        }
    }

    private boolean areStabilizersActive() {
        for (MultiblockHelper.TileLocation stabilizer : this.stabilizers) {
            TileEntity tile = stabilizer.getTileEntity(this.field_145850_b);
            if (!(tile instanceof TileParticleGenerator)) {
                return false;
            }
            TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
            if (!particleGenerator.isInStabilizerMode || stabilizer.getBlockMetadata(this.field_145850_b) != 1) {
                return false;
            }
            TileEnergyStorageCore core = particleGenerator.getMaster();
            if (core != null && core.field_145851_c == this.field_145851_c && core.field_145848_d == this.field_145848_d && core.field_145849_e == this.field_145849_e) continue;
            return false;
        }
        return true;
    }

    public int getTier() {
        return this.tier;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("Online", this.online);
        compound.func_74777_a("Tier", (short)this.tier);
        compound.func_74772_a("EnergyL", this.energy);
        for (int i = 0; i < this.stabilizers.length; ++i) {
            this.stabilizers[i].writeToNBT(compound, String.valueOf(i));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.online = compound.func_74767_n("Online");
        this.tier = compound.func_74765_d("Tier");
        this.energy = compound.func_74763_f("EnergyL");
        if (compound.func_74764_b("Energy")) {
            this.energy = (long)compound.func_74769_h("Energy");
        }
        for (int i = 0; i < this.stabilizers.length; ++i) {
            this.stabilizers[i].readFromNBT(compound, String.valueOf(i));
        }
        this.initializeCapacity();
        super.func_145839_a(compound);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long energyReceived = Math.min(this.capacity - this.energy, (long)maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long energyExtracted = Math.min(this.energy, (long)maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    public long getEnergyStored() {
        return this.energy;
    }

    public long getMaxEnergyStored() {
        return this.capacity;
    }

    public List<String> getDisplayInformation(boolean shouldShowName) {
        ArrayList<String> information = new ArrayList<String>();
        if (shouldShowName) {
            information.add(InfoHelper.HITC() + ModBlocks.energyStorageCore.func_149732_F());
        }
        information.add(StatCollector.func_74838_a((String)"info.de.tier.txt") + ": " + InfoHelper.ITC() + (this.tier + 1));
        information.add(StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + InfoHelper.ITC() + Utills.formatNumber((long)this.energy) + " / " + Utills.formatNumber((long)this.capacity) + " [" + Utills.addCommas((long)this.energy) + " RF]");
        return information;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    private void detectAndSendChanges() {
        if (this.lastTickCapacity != this.energy) {
            this.lastTickCapacity = (Long)this.sendObjectToClient((byte)3, 0, this.energy, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 20.0));
        }
    }

    @Override
    public void receiveObjectFromServer(int index, Object object) {
        this.energy = (Long)object;
    }

    @FunctionalInterface
    private static interface IBlockAction {
        public boolean process(int var1, int var2, int var3);
    }
}

