/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.ParticleCustom;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ParticleGenerator
extends BlockDE
implements ITileEntityProvider {
    public static Block instance;

    public ParticleGenerator() {
        this.func_149663_c("particleGenerator");
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149672_a(field_149769_e);
        this.func_149713_g(0);
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_side");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileParticleGenerator particleGenerator;
        TileEntity tile;
        if (world.func_72805_g(x, y, z) == 1) {
            return false;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151121_aF && (tile = world.func_147438_o(x, y, z)) instanceof TileParticleGenerator) {
            particleGenerator = (TileParticleGenerator)tile;
            ItemStack stack = player.func_70694_bm();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("particles_enabled")) {
                particleGenerator.setBlockNBT(stack.func_77978_p());
                return true;
            }
        }
        if (player.func_70093_af()) {
            if (this.activateEnergyStorageCore(world, x, y, z, player)) {
                return true;
            }
            tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileParticleGenerator) {
                particleGenerator = (TileParticleGenerator)tile;
                particleGenerator.toggleInverted();
            }
        } else {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)5, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return -1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileParticleGenerator) {
            TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
            particleGenerator.hasRedstoneSignal = world.func_72864_z(x, y, z);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149664_b(World world, int x, int y, int z, int metadata) {
        if (!world.field_72995_K) {
            return;
        }
        Random rand = world.field_73012_v;
        float modifier = 0.1f;
        float scale = 1.0f;
        double spawnX = (double)x + 0.5;
        double spawnY = (double)y + 0.5;
        double spawnZ = (double)z + 0.5;
        for (int i = 0; i < 100; ++i) {
            float motionX = modifier - 2.0f * modifier * rand.nextFloat();
            float motionY = modifier - 2.0f * modifier * rand.nextFloat();
            float motionZ = modifier - 2.0f * modifier * rand.nextFloat();
            ParticleCustom particle = new ParticleCustom(world, spawnX, spawnY, spawnZ, motionX, motionY, motionZ, scale, false, 1);
            particle.red = rand.nextInt(255);
            particle.green = rand.nextInt(255);
            particle.blue = rand.nextInt(255);
            particle.maxAge = rand.nextInt(10);
            particle.fadeTime = 20;
            particle.fadeLength = 20;
            particle.gravity = 0.0f;
            ParticleHandler.spawnCustomParticle(particle);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess worldIn, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileParticleGenerator();
    }

    private boolean activateEnergyStorageCore(World world, int x, int y, int z, EntityPlayer player) {
        ForgeDirection[] horizontalDirections;
        for (ForgeDirection direction : horizontalDirections = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH}) {
            for (int distance = 1; distance <= 11; ++distance) {
                int coreX = x + direction.offsetX * distance;
                int coreZ = z + direction.offsetZ * distance;
                if (world.func_147439_a(coreX, y, coreZ) != ModBlocks.energyStorageCore) continue;
                return this.tryActivateEnergyStorageCore(world, coreX, y, coreZ, player);
            }
        }
        return false;
    }

    private boolean tryActivateEnergyStorageCore(World world, int coreX, int coreY, int coreZ, EntityPlayer player) {
        TileEntity tile = world.func_147438_o(coreX, coreY, coreZ);
        if (tile instanceof TileEnergyStorageCore) {
            TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
            if (core.tryActivate(player.field_71075_bZ.field_75098_d)) {
                return true;
            }
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.energyStorageCoreUTA.txt", new Object[0]));
            }
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int metadata) {
        TileParticleGenerator particleGenerator;
        TileEntity tile;
        if (metadata == 1 && (tile = world.func_147438_o(x, y, z)) instanceof TileParticleGenerator && (particleGenerator = (TileParticleGenerator)tile).getMaster() != null) {
            world.func_72921_c(x, y, z, 0, 2);
            particleGenerator.getMaster().validateStructure(true);
        }
        super.func_149749_a(world, x, y, z, blockBroken, metadata);
    }
}

