/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.networking.IGridHost;
import appeng.me.Grid;
import appeng.server.ISubCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class Profile
implements ISubCommand {
    @Override
    public String getHelp(MinecraftServer srv) {
        return "commands.ae2.Profiler";
    }

    @Override
    public void call(MinecraftServer srv, String[] args, ICommandSender sender) {
        if (args.length < 4) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.Profiler", new Object[0]));
        }
        try {
            TileEntity tile;
            int x = Integer.decode(args[1]);
            int y = Integer.decode(args[2]);
            int z = Integer.decode(args[3]);
            if (args.length > 4) {
                int dim = Integer.decode(args[4]);
                WorldServer ws = srv.func_71218_a(dim);
                if (ws == null) {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.ProfilerFailedDim", new Object[0]));
                    return;
                }
                tile = ws.func_147438_o(x, y, z);
            } else {
                tile = sender.func_130014_f_().func_147438_o(x, y, z);
            }
            if (!(tile instanceof IGridHost) || ((IGridHost)tile).getGridNode(ForgeDirection.UNKNOWN) == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.ProfilerFailed", new Object[0]));
                return;
            }
            Grid grid = (Grid)((IGridHost)tile).getGridNode(ForgeDirection.UNKNOWN).getGrid();
            if (grid == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.ProfilerGridDown", new Object[0]));
                return;
            }
            if (!grid.isProfiling()) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.ProfilerStart", new Object[0]));
                grid.startProfiling();
            } else {
                ChatComponentTranslation message = new ChatComponentTranslation("commands.ae2.ProfilerStop", new Object[0]);
                message.func_150258_a(String.format(" %d", grid.stopProfiling()));
                sender.func_145747_a((IChatComponent)message);
            }
        }
        catch (NumberFormatException ex) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ae2.ProfilerFailed", new Object[0]));
            return;
        }
    }
}

