/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.CraftingMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.me.cache.CraftingGridCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketCraftRequest
extends AppEngPacket {
    private final long amount;
    private final boolean heldShift;
    private final CraftingMode craftingMode;

    public PacketCraftRequest(ByteBuf stream) {
        this.heldShift = stream.readBoolean();
        this.amount = stream.readLong();
        this.craftingMode = CraftingMode.values()[stream.readByte()];
    }

    public PacketCraftRequest(int craftAmt, boolean shift) {
        this(craftAmt, shift, CraftingMode.STANDARD);
    }

    public PacketCraftRequest(int craftAmt, boolean shift, CraftingMode craftingMode) {
        this.amount = craftAmt;
        this.heldShift = shift;
        this.craftingMode = craftingMode;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        data.writeLong(this.amount);
        data.writeByte(craftingMode.ordinal());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerCraftAmount cca;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerCraftAmount && (target = (cca = (ContainerCraftAmount)container).getTarget()) instanceof IGridHost) {
            IGridHost gh = (IGridHost)target;
            IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future<ICraftingJob> futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                if (cg instanceof CraftingGridCache) {
                    CraftingGridCache cgc = (CraftingGridCache)cg;
                    futureJob = cgc.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), this.craftingMode, null);
                } else {
                    futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                }
                ContainerOpenContext context = cca.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    cca.openConfirmationGUI(player, te);
                    Container container2 = player.field_71070_bA;
                    if (container2 instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)container2;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug(e);
            }
        }
    }
}

