/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.List;

public class BlockPosHighlighter {
    private static final List<DimensionalCoord> highlightedBlocks = new ArrayList<DimensionalCoord>();
    private static long expireHighlight;
    private static final int min = 3000;
    private static final int max = 30000;

    public static void highlightBlock(DimensionalCoord c, long expireHighlight) {
        BlockPosHighlighter.highlightBlock(c, expireHighlight, true);
    }

    public static void highlightBlock(DimensionalCoord c, long expireHighlight, boolean clear) {
        if (clear) {
            BlockPosHighlighter.clear();
        }
        highlightedBlocks.add(c);
        BlockPosHighlighter.expireHighlight = Math.max(BlockPosHighlighter.expireHighlight, Math.min(System.currentTimeMillis() + 30000L, Math.max(expireHighlight, System.currentTimeMillis() + 3000L)));
    }

    public static List<DimensionalCoord> getHighlightedBlocks() {
        return highlightedBlocks;
    }

    public static DimensionalCoord getHighlightedBlock() {
        return highlightedBlocks.isEmpty() ? null : highlightedBlocks.get(0);
    }

    public static void clear() {
        highlightedBlocks.clear();
        expireHighlight = -1L;
    }

    public static void remove(DimensionalCoord c) {
        highlightedBlocks.remove(c);
    }

    public static long getExpireHighlight() {
        return expireHighlight;
    }
}

