/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternValueAmount;
import appeng.core.AEConfig;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketPatternValueSet;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiPatternValueAmount
extends AEBaseGui {
    private GuiTextField amountToSet;
    private GuiTabButton originalGuiBtn;
    private GuiButton set;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GuiBridge originalGui;
    private final int valueIndex;
    private final int originalAmount;

    public GuiPatternValueAmount(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerPatternValueAmount(inventoryPlayer, te));
        GuiContainer gui = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        if (gui != null && gui.field_147006_u != null && gui.field_147006_u.func_75216_d()) {
            Slot slot = gui.field_147006_u;
            this.originalAmount = slot.func_75211_c().field_77994_a;
            this.valueIndex = slot.field_75222_d;
        } else {
            this.valueIndex = -1;
            this.originalAmount = 0;
        }
    }

    @Override
    public void func_73866_w_() {
        ItemStack stack;
        Iterator iterator;
        super.func_73866_w_();
        int a = AEConfig.instance.craftItemsByStackAmounts(0);
        int b = AEConfig.instance.craftItemsByStackAmounts(1);
        int c = AEConfig.instance.craftItemsByStackAmounts(2);
        int d = AEConfig.instance.craftItemsByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 26, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 26, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 26, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 26, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 75, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 75, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 75, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 75, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.set = new GuiButton(0, this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.getLocal());
        this.field_146292_n.add(this.set);
        ItemStack myIcon = null;
        Object target = ((AEBaseContainer)this.field_147002_h).getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartPatternTerminalEx) {
            iterator = parts.patternTerminalEx().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
        if (this.originalGui != null && myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, myIcon, myIcon.func_82833_r(), field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
        }
        this.amountToSet = new GuiTextField(this.field_146289_q, this.field_147003_i + 62, this.field_147009_r + 57, 59, this.field_146289_q.field_78288_b);
        this.amountToSet.func_146185_a(false);
        this.amountToSet.func_146203_f(16);
        this.amountToSet.func_146193_g(GuiColors.CraftAmountToCraft.getColor());
        this.amountToSet.func_146189_e(true);
        this.amountToSet.func_146195_b(true);
        this.amountToSet.func_146180_a(String.valueOf(this.originalAmount));
        this.amountToSet.func_146199_i(0);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, GuiColors.CraftAmountSelectAmount.getColor());
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.set.field_146126_j = GuiText.Set.getLocal();
        this.set.field_146124_l = this.valueIndex >= 0;
        this.bindTexture("guis/craftAmt.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        try {
            String out = this.amountToSet.func_146179_b();
            double resultD = Calculator.conversion(out);
            int resultI = resultD <= 0.0 || Double.isNaN(resultD) ? 0 : (int)ArithHelper.round(resultD, 0);
            this.set.field_146124_l = resultI > 0;
        }
        catch (NumberFormatException e) {
            this.set.field_146124_l = false;
        }
        this.amountToSet.func_146194_f();
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.set);
            }
            this.amountToSet.func_146201_a(character, key);
            super.func_73869_a(character, key);
        }
    }

    protected void func_146284_a(GuiButton btn) {
        boolean isMinus;
        super.func_146284_a(btn);
        try {
            if (btn == this.originalGuiBtn) {
                NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
            }
            if (btn == this.set && btn.field_146124_l) {
                double resultD = Calculator.conversion(this.amountToSet.func_146179_b());
                int resultI = resultD <= 0.0 || Double.isNaN(resultD) ? 1 : (int)ArithHelper.round(resultD, 0);
                NetworkHandler.instance.sendToServer(new PacketPatternValueSet(this.originalGui.ordinal(), resultI, this.valueIndex));
            }
        }
        catch (NumberFormatException e) {
            this.amountToSet.func_146180_a("1");
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(int i) {
        try {
            String out = this.amountToSet.func_146179_b();
            double resultD = Calculator.conversion(out);
            int resultI = resultD <= 0.0 || Double.isNaN(resultD) ? 0 : (int)ArithHelper.round(resultD, 0);
            if (resultI == 1 && i > 1) {
                resultI = 0;
            }
            if ((resultI += i) < 1) {
                resultI = 1;
            }
            out = Integer.toString(resultI);
            this.amountToSet.func_146180_a(out);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

