/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenPadauk
extends WorldGenTree {
    public WorldGenPadauk(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 3.0f, 1, this.leaf);
        int count = 0;
        int max = 3;
        int min = 1;
        int canopyHeight = world.field_73012_v.nextInt(max - min + 1) + min;
        while (leafSpawn > 3 && count < canopyHeight) {
            this.generateAdjustedCylinder(world, leafSpawn--, 4.5f, 1, this.leaf);
            ++count;
            for (int i = 0; i < this.girth * 4; ++i) {
                if (!world.field_73012_v.nextBoolean()) continue;
                int[] offset = new int[]{-1, 1};
                int offsetValue = offset[new Random().nextInt(offset.length)];
                int maxBranchLength = 3;
                int branchLength = new Random().nextInt(maxBranchLength + 1);
                ForgeDirection[] direction = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST};
                ForgeDirection directionValue = direction[new Random().nextInt(direction.length)];
                int branchSpawn = leafSpawn;
                for (int j = 1; j < branchLength + 1; ++j) {
                    if (j == branchLength && world.field_73012_v.nextBoolean()) {
                        ++branchSpawn;
                    }
                    this.wood.setDirection(directionValue);
                    if (directionValue == ForgeDirection.NORTH) {
                        this.addWood(world, 0, branchSpawn, j * offsetValue, WorldGenBase.EnumReplaceMode.ALL);
                        continue;
                    }
                    if (directionValue != ForgeDirection.EAST) continue;
                    this.addWood(world, j * offsetValue, branchSpawn, 0, WorldGenBase.EnumReplaceMode.ALL);
                }
            }
        }
    }
}

