/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.ILifeDatabase;
import betterquesting.storage.QuestSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public final class LifeDatabase
implements ILifeDatabase {
    public static final LifeDatabase INSTANCE = new LifeDatabase();
    private final HashMap<UUID, Integer> playerLives = new HashMap();

    @Override
    public synchronized int getLives(@Nonnull UUID uuid) {
        return this.playerLives.computeIfAbsent(uuid, k -> QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF));
    }

    @Override
    public synchronized void setLives(@Nonnull UUID uuid, int value) {
        this.playerLives.put(uuid, MathHelper.func_76125_a((int)value, (int)0, (int)QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX)));
    }

    @Override
    public synchronized NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jul = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            if (users != null && !users.contains(entry.getKey())) continue;
            NBTTagCompound j = new NBTTagCompound();
            j.func_74778_a("uuid", entry.getKey().toString());
            j.func_74768_a("lives", entry.getValue().intValue());
            jul.func_74742_a((NBTBase)j);
        }
        nbt.func_74782_a("playerLives", (NBTBase)jul);
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.playerLives.clear();
        }
        NBTTagList tagList = nbt.func_150295_c("playerLives", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound j = tagList.func_150305_b(i);
            try {
                UUID uuid = UUID.fromString(j.func_74779_i("uuid"));
                int lives = j.func_74762_e("lives");
                this.playerLives.put(uuid, lives);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.playerLives.clear();
    }
}

