/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw.scroll;

import codechicken.lib.gui.GuiDraw;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.MouseButton;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollDirection;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollManager;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollOrientation;

class Scrollbar {
    private static final int PADDING = 2;
    private static final int OFFSET = 8;
    private static final int MIN_CURSOR_LENGTH = 2;
    private static final int CURSOR_RADIUS = 3;
    private static final int SCROLLBAR_RADIUS = 1;
    private static final int MOUSEOVER_PADDING = 4;
    private static final int FADE_TICKS = 24;
    private static final int FOREGROUND_COLOUR = 1334688;
    private static final int FOREGROUND_SELECTED_COLOUR = 3050432;
    private static final int BACKGROUND_COLOUR = 11654368;
    private static final int FOREGROUND_COLOUR_OPACITY = 240;
    private static final int BACKGROUND_COLOUR_OPACITY = 144;
    private final ScrollManager scrollManager;
    private final ScrollOrientation orientation;
    private final ScrollbarDimensions dimensions;
    private int scroll;
    private boolean selected;
    private int fade;

    public Scrollbar(ScrollManager scrollManager, ScrollOrientation orientation) {
        this.scrollManager = scrollManager;
        this.orientation = orientation;
        this.dimensions = new ScrollbarDimensions();
        this.scroll = 0;
        this.selected = false;
        this.fade = 24;
    }

    public int getScroll() {
        return this.scroll;
    }

    public boolean scroll(ScrollDirection direction, int amount) {
        int scrollAmount = this.orientation.dotProduct(direction) * amount;
        if (this.dimensions.offscreenLength <= 0 || scrollAmount == 0) {
            return false;
        }
        this.scroll += scrollAmount;
        this.fade = 24;
        return true;
    }

    public boolean mouseClickScrollbar(MouseButton button) {
        if (!this.mouseInScrollBounds()) {
            if (this.selected) {
                this.selected = false;
                return true;
            }
            return false;
        }
        switch (button) {
            case LEFT: {
                this.selected = !this.selected;
                return true;
            }
            case RIGHT: {
                this.scrollToMouse();
                return true;
            }
        }
        return false;
    }

    public void scrollToMouse() {
        int mousePos = this.orientation.dotProduct(this.scrollManager.getAbsoluteMousePosition());
        int mouseOffset = mousePos - this.orientation.dotProduct(this.dimensions.anchor) - this.dimensions.cursorLength / 2;
        this.scroll = mouseOffset * this.dimensions.offscreenLength / this.dimensions.scrollableLength;
        this.fade = 24;
    }

    public boolean mouseInScrollBounds() {
        int minX = this.dimensions.anchor.x() - 4;
        int maxX = this.dimensions.end.x() + 4;
        int minY = this.dimensions.anchor.y() - 4;
        int maxY = this.dimensions.end.y() + 4;
        Point mousePos = this.scrollManager.getAbsoluteMousePosition();
        return mousePos.x() >= minX && mousePos.x() <= maxX && mousePos.y() >= minY && mousePos.y() <= maxY;
    }

    public void tick() {
        if (this.mouseInScrollBounds()) {
            this.fade = 24;
        } else if (this.fade > 0) {
            --this.fade;
        }
    }

    public void refreshState(Dimension diagramDimension) {
        this.dimensions.compute(diagramDimension);
        if (this.dimensions.offscreenLength <= 0) {
            this.scroll = 0;
            this.selected = false;
            this.fade = 0;
            return;
        }
        if (this.selected) {
            this.scrollToMouse();
        }
        if (this.scroll > this.dimensions.offscreenLength) {
            this.scroll = this.dimensions.offscreenLength;
        } else if (this.scroll < 0) {
            this.scroll = 0;
        }
    }

    public void draw() {
        if (this.fade <= 0) {
            return;
        }
        int fadeOpacity = Math.min(2 * this.fade, 24);
        int fgOpacity = 240 * fadeOpacity / 24;
        int bgOpacity = 144 * fadeOpacity / 24;
        int fgColour = this.selected ? 3050432 : 1334688;
        fgColour |= fgOpacity << 24;
        int bgColour = 0xB1D4E0 | bgOpacity << 24;
        int scrollbarAboveLength = this.scroll * this.dimensions.scrollableLength / this.dimensions.offscreenLength;
        Point scrollbarAboveStart = this.dimensions.anchor.translate(this.orientation.transposeScale(-1));
        Dimension scrollbarAboveDimension = Dimension.create(scrollbarAboveLength, 2);
        int scrollbarAboveWidth = this.orientation.dotProduct(scrollbarAboveDimension);
        int scrollbarAboveHeight = this.orientation.transposeProduct(scrollbarAboveDimension);
        Point cursorStart = this.dimensions.anchor.translate(this.orientation.scale(scrollbarAboveLength));
        cursorStart = cursorStart.translate(this.orientation.transposeScale(-3));
        Dimension cursorDimension = Dimension.create(this.dimensions.cursorLength, 6);
        int cursorWidth = this.orientation.dotProduct(cursorDimension);
        int cursorHeight = this.orientation.transposeProduct(cursorDimension);
        int scrollbarBelowLength = this.dimensions.scrollbarLength - (scrollbarAboveLength + this.dimensions.cursorLength);
        Point scrollbarBelowStart = this.dimensions.end.translate(this.orientation.scale(-scrollbarBelowLength));
        scrollbarBelowStart = scrollbarBelowStart.translate(this.orientation.transposeScale(-1));
        Dimension scrollbarBelowDimension = Dimension.create(scrollbarBelowLength, 2);
        int scrollbarBelowWidth = this.orientation.dotProduct(scrollbarBelowDimension);
        int scrollbarBelowHeight = this.orientation.transposeProduct(scrollbarBelowDimension);
        if (scrollbarAboveLength > 0) {
            GuiDraw.drawRect((int)scrollbarAboveStart.x(), (int)scrollbarAboveStart.y(), (int)scrollbarAboveWidth, (int)scrollbarAboveHeight, (int)bgColour);
        }
        GuiDraw.drawRect((int)cursorStart.x(), (int)cursorStart.y(), (int)cursorWidth, (int)cursorHeight, (int)fgColour);
        if (scrollbarBelowLength > 0) {
            GuiDraw.drawRect((int)scrollbarBelowStart.x(), (int)scrollbarBelowStart.y(), (int)scrollbarBelowWidth, (int)scrollbarBelowHeight, (int)bgColour);
        }
    }

    private class ScrollbarDimensions {
        private Point anchor = Point.create(0, 0);
        private Point end = Point.create(0, 0);
        private int scrollbarLength = 0;
        private int cursorLength = 0;
        private int scrollableLength = 0;
        private int viewportLength = 0;
        private int diagramLength = 0;
        private int offscreenLength = 0;

        private ScrollbarDimensions() {
        }

        public void compute(Dimension diagramDimension) {
            Point viewportPos = Scrollbar.this.scrollManager.getViewportPosition();
            Dimension viewportDim = Scrollbar.this.scrollManager.getViewportDimension();
            this.scrollbarLength = this.viewportLength = Scrollbar.this.orientation.dotProduct(viewportDim);
            this.anchor = viewportPos.translate(Scrollbar.this.orientation.transposeScale(Scrollbar.this.orientation.transposeProduct(viewportDim) + 8));
            this.end = this.anchor.translate(Scrollbar.this.orientation.scale(this.scrollbarLength));
            this.diagramLength = Scrollbar.this.orientation.dotProduct(diagramDimension) + 2;
            this.offscreenLength = this.diagramLength - this.viewportLength;
            this.cursorLength = Math.max(this.viewportLength * this.scrollbarLength / this.diagramLength, 2);
            this.scrollableLength = this.scrollbarLength - this.cursorLength;
        }
    }
}

