/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.mitchej123.hodgepodge.Common;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class AnchorAlarm {
    private static final String NBT_KEY = "GT_RC_AnchorAlarmList";
    public static boolean AnchorDebug = false;

    public static void addNewAnchor(EntityLivingBase entityliving, TileEntity te) {
        if (entityliving instanceof EntityPlayerMP) {
            byte[] oldbuf = null;
            if (entityliving.getEntityData().func_74764_b(NBT_KEY)) {
                oldbuf = entityliving.getEntityData().func_74770_j(NBT_KEY);
            }
            byte[] newbuf = new byte[(oldbuf == null ? 0 : oldbuf.length) + 16];
            ByteBuf newbufwrap = Unpooled.wrappedBuffer((byte[])newbuf);
            newbufwrap.setIndex(0, 0);
            if (oldbuf != null) {
                newbufwrap.writeBytes(oldbuf);
            }
            AnchorAlarm.saveCoordinatesToPlayer(entityliving, newbufwrap, newbuf, te);
        }
    }

    public static boolean listSavedAnchors(String playerName, World w) {
        for (Object obj : w.field_73010_i) {
            if (!((EntityPlayer)obj).getDisplayName().equals(playerName)) continue;
            NBTTagCompound nbt = ((EntityPlayer)obj).getEntityData();
            if (!nbt.func_74764_b(NBT_KEY)) {
                Common.log.debug("[AnchorDebug] No anchors listed for player " + playerName);
            } else {
                byte[] bytes = nbt.func_74770_j(NBT_KEY);
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
                int N = bytes.length / 16;
                for (int i = 0; i < N; ++i) {
                    int dim = buf.readInt();
                    int x = buf.readInt();
                    int y = buf.readInt();
                    int z = buf.readInt();
                    Common.log.debug("[AnchorDebug] Anchor (" + x + ", " + y + ", " + z + ") at dim " + dim + " for player " + playerName);
                }
            }
            return true;
        }
        return false;
    }

    private static void saveCoordinatesToPlayer(EntityLivingBase player, ByteBuf buf, byte[] bytes, TileEntity te) {
        buf.writeInt(te.func_145831_w().field_73011_w.field_76574_g);
        buf.writeInt(te.field_145851_c);
        buf.writeInt(te.field_145848_d);
        buf.writeInt(te.field_145849_e);
        player.getEntityData().func_74773_a(NBT_KEY, bytes);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            if (AnchorDebug) {
                Common.log.debug("[AnchorDebug] Loading anchors for player " + event.player.getDisplayName());
            }
            if (event.player.getEntityData().func_74764_b(NBT_KEY)) {
                byte[] bytes = event.player.getEntityData().func_74770_j(NBT_KEY);
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
                int N = bytes.length / 16;
                ByteBuf newbuf = Unpooled.buffer((int)bytes.length);
                int validAlarmCount = 0;
                try {
                    HashSet<TileEntity> loadedTiles = new HashSet<TileEntity>();
                    for (int i = 0; i < N; ++i) {
                        int dim = buf.readInt();
                        int x = buf.readInt();
                        int y = buf.readInt();
                        int z = buf.readInt();
                        WorldServer w = DimensionManager.getWorld((int)dim);
                        if (w == null) {
                            if (AnchorDebug) {
                                System.out.println("[AnchorDebug] Loading dimension " + dim);
                            }
                            DimensionManager.initDimension((int)dim);
                            w = DimensionManager.getWorld((int)dim);
                        }
                        if (w != null) {
                            w.func_72863_F().func_73154_d(x >> 4, z >> 4);
                            TileEntity t = w.func_147438_o(x, y, z);
                            if (loadedTiles.contains(t)) continue;
                            loadedTiles.add(t);
                            if (AnchorDebug) {
                                System.out.println("[AnchorDebug] Loading anchor at (" + x + ", " + y + ", " + z + ") at dim " + dim);
                            }
                            if (t instanceof TileAnchorWorld) {
                                if (PlayerPlugin.isSamePlayer((GameProfile)((TileAnchorWorld)t).getOwner(), (GameProfile)event.player.func_146103_bH())) {
                                    t.func_145845_h();
                                    ++validAlarmCount;
                                    newbuf.writeInt(dim);
                                    newbuf.writeInt(x);
                                    newbuf.writeInt(y);
                                    newbuf.writeInt(z);
                                    continue;
                                }
                                if (!AnchorDebug) continue;
                                System.out.println("[AnchorDebug] Someone else's anchor at (" + x + ", " + y + ", " + z + ") at dim " + dim);
                                continue;
                            }
                            if (!AnchorDebug) continue;
                            System.out.println("[AnchorDebug] Failed loading anchor at (" + x + ", " + y + ", " + z + ") at dim " + dim);
                            continue;
                        }
                        if (!AnchorDebug) continue;
                        System.out.println("[AnchorDebug] Failed loading dimension " + dim);
                    }
                }
                catch (IndexOutOfBoundsException ignored) {
                    Common.log.error("Error reading anchor list!");
                }
                byte[] newbytes = new byte[validAlarmCount * 16];
                newbuf.readBytes(newbytes);
                event.player.getEntityData().func_74773_a(NBT_KEY, newbytes);
            } else if (AnchorDebug) {
                System.out.println("[AnchorDebug] No listed anchors for player " + event.player.getDisplayName());
            }
        }
    }
}

