/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.transformers.early;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class EarlyClassTransformer
implements IClassTransformer {
    private static final boolean noNukeBaseMod;
    private static final Logger LOGGER;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || name == null) {
            return basicClass;
        }
        switch (name) {
            case "cpw.mods.fml.common.ModContainerFactory": {
                if (noNukeBaseMod) {
                    return basicClass;
                }
                return EarlyClassTransformer.transformModContainerFactory(basicClass);
            }
        }
        return basicClass;
    }

    private static byte[] transformModContainerFactory(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(0);
        ClassVisitor cv = new ClassVisitor(327680, (ClassVisitor)cw){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ("modClass".equals(name)) {
                    return null;
                }
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                switch (name) {
                    case "build": {
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(25, 2);
                        mv.visitVarInsn(25, 3);
                        mv.visitMethodInsn(184, "com/mitchej123/hodgepodge/asm/hooks/early/EarlyASMCallHooks", "build", "(Lcpw/mods/fml/common/discovery/asm/ASMModParser;Ljava/io/File;Lcpw/mods/fml/common/discovery/ModCandidate;)Lcpw/mods/fml/common/ModContainer;", false);
                        mv.visitInsn(176);
                        mv.visitMaxs(3, 4);
                        mv.visitEnd();
                        return null;
                    }
                    case "<clinit>": {
                        mv = new MethodVisitor(327680, mv){

                            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                                if (name.equals("modClass")) {
                                    super.visitInsn(87);
                                } else {
                                    super.visitFieldInsn(opcode, owner, name, desc);
                                }
                            }
                        };
                    }
                }
                return mv;
            }
        };
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    static {
        Throwable throwable;
        Closeable r;
        LOGGER = LogManager.getLogger((String)"HodgePodgeEarly");
        Properties config = new Properties();
        File configLocation = new File(Launch.minecraftHome, "config/hodgepodgeEarly.properties");
        try {
            r = new BufferedReader(new FileReader(configLocation));
            throwable = null;
            try {
                config.load((Reader)r);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)r).close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("No existing configuration file. Will use defaults");
        }
        catch (IOException e) {
            LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
        }
        noNukeBaseMod = Boolean.parseBoolean(config.getProperty("noNukeBaseMod"));
        config.setProperty("noNukeBaseMod", String.valueOf(noNukeBaseMod));
        try {
            r = new BufferedWriter(new FileWriter(configLocation));
            throwable = null;
            try {
                config.store((Writer)r, "Configuration file for early hodgepodge class transformers");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)r).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)r).close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
        }
    }
}

