/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.network;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.network.ProspectingNotification;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ProspectingRequest
implements IMessage {
    public static long timestampLastRequest = 0L;
    private int dimensionId;
    private int blockX;
    private int blockY;
    private int blockZ;
    private short foundOreMetaData;

    public ProspectingRequest() {
    }

    public ProspectingRequest(int dimensionId, int blockX, int blockY, int blockZ, short foundOreMetaData) {
        this.dimensionId = dimensionId;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.foundOreMetaData = foundOreMetaData;
    }

    public static boolean canSendRequest() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - timestampLastRequest > (long)Config.minDelayBetweenVeinRequests) {
            timestampLastRequest = timestamp;
            return true;
        }
        return false;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionId = buf.readInt();
        this.blockX = buf.readInt();
        this.blockY = buf.readInt();
        this.blockZ = buf.readInt();
        this.foundOreMetaData = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensionId);
        buf.writeInt(this.blockX);
        buf.writeInt(this.blockY);
        buf.writeInt(this.blockZ);
        buf.writeShort((int)this.foundOreMetaData);
    }

    public static class Handler
    implements IMessageHandler<ProspectingRequest, IMessage> {
        private static final Map<UUID, Long> lastRequestPerPlayer = new HashMap<UUID, Long>();

        public IMessage onMessage(ProspectingRequest message, MessageContext ctx) {
            short metaData;
            TileEntity tileEntity;
            Block block;
            UUID uuid = ctx.getServerHandler().field_147369_b.func_110124_au();
            long lastRequest = lastRequestPerPlayer.containsKey(uuid) ? lastRequestPerPlayer.get(uuid) : 0L;
            long timestamp = System.currentTimeMillis();
            float distanceSquared = ctx.getServerHandler().field_147369_b.func_82114_b().func_71569_e(message.blockX, message.blockY, message.blockZ);
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            int chunkX = Utils.coordBlockToChunk(message.blockX);
            int chunkZ = Utils.coordBlockToChunk(message.blockZ);
            boolean isChunkLoaded = world.func_72863_F().func_73149_a(chunkX, chunkZ);
            if (ctx.getServerHandler().field_147369_b.field_71093_bK == message.dimensionId && distanceSquared <= 1024.0f && timestamp - lastRequest >= (long)Config.minDelayBetweenVeinRequests && isChunkLoaded && (block = world.func_147439_a(message.blockX, message.blockY, message.blockZ)) instanceof GT_Block_Ores_Abstract && (tileEntity = world.func_147438_o(message.blockX, message.blockY, message.blockZ)) instanceof GT_TileEntity_Ores && !Utils.isSmallOreId(metaData = ((GT_TileEntity_Ores)tileEntity).mMetaData) && Utils.oreIdToMaterialId(metaData) == message.foundOreMetaData) {
                lastRequestPerPlayer.put(uuid, timestamp);
                OreVeinPosition centerOreVeinPosition = ServerCache.instance.getOreVein(message.dimensionId, chunkX, chunkZ);
                if (centerOreVeinPosition.veinType.containsOre(message.foundOreMetaData)) {
                    return new ProspectingNotification(centerOreVeinPosition);
                }
                int centerChunkX = Utils.mapToCenterOreChunkCoord(chunkX);
                int centerChunkZ = Utils.mapToCenterOreChunkCoord(chunkZ);
                for (int offsetChunkX = -3; offsetChunkX <= 3; offsetChunkX += 3) {
                    for (int offsetChunkZ = -3; offsetChunkZ <= 3; offsetChunkZ += 3) {
                        if (offsetChunkX == 0 && offsetChunkZ == 0) continue;
                        int neighborChunkX = centerChunkX + offsetChunkX;
                        int neighborChunkZ = centerChunkZ + offsetChunkZ;
                        int distanceBlocks = Math.max(Math.abs(neighborChunkX - chunkX), Math.abs(neighborChunkZ - chunkZ));
                        OreVeinPosition neighborOreVeinPosition = ServerCache.instance.getOreVein(message.dimensionId, neighborChunkX, neighborChunkZ);
                        int maxDistance = (neighborOreVeinPosition.veinType.blockSize + 16 >> 4) + 1;
                        if (!neighborOreVeinPosition.veinType.containsOre(message.foundOreMetaData) || distanceBlocks > maxDistance) continue;
                        return new ProspectingNotification(neighborOreVeinPosition);
                    }
                }
            }
            return null;
        }
    }
}

