/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.item;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.TransferCache;
import com.sinthoras.visualprospecting.task.SnapshotDownloadTask;
import com.sinthoras.visualprospecting.task.SnapshotUploadTask;
import com.sinthoras.visualprospecting.task.TaskManager;
import gregtech.api.GregTech_API;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ProspectorsLog
extends Item {
    public static ProspectorsLog instance;

    public ProspectorsLog() {
        this.field_77777_bU = 1;
        this.func_77655_b("visualprospecting.prospectorslog");
        this.func_77637_a(GregTech_API.TAB_GREGTECH);
        this.func_111206_d("visualprospecting:prospectorslog");
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        NBTTagCompound compound;
        String authorUuid;
        if (!this.isFilledLog(item)) {
            NBTTagCompound compound2 = new NBTTagCompound();
            compound2.func_74778_a("log_author", player.getDisplayName());
            compound2.func_74778_a("log_author_id", player.getPersistentID().toString());
            item.func_77982_d(compound2);
            if (world.field_72995_K) {
                TaskManager.instance.addTask(new SnapshotUploadTask());
            } else {
                int random = VP.randomGeneration.nextInt(1000);
                if (random < 5) {
                    String localizationKey = "item.visualprospecting.prospectorslog.creation.fail" + random;
                    ChatComponentTranslation notification = new ChatComponentTranslation(localizationKey, new Object[0]);
                    notification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    notification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                    player.func_145747_a((IChatComponent)notification);
                    player.func_71028_bD();
                } else {
                    ChatComponentTranslation notification = new ChatComponentTranslation("item.visualprospecting.prospectorslog.creation.begin", new Object[0]);
                    notification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    notification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                    player.func_145747_a((IChatComponent)notification);
                }
            }
        } else if (!world.field_72995_K && !(authorUuid = (compound = item.func_77978_p()).func_74779_i("log_author_id")).equals(player.getPersistentID().toString())) {
            int random = VP.randomGeneration.nextInt(TransferCache.instance.isClientDataAvailable(authorUuid) ? 1000 : 5);
            if (random < 5) {
                String localizationKey = "item.visualprospecting.prospectorslog.reading.fail" + random;
                ChatComponentTranslation notification = new ChatComponentTranslation(localizationKey, new Object[0]);
                notification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                notification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                player.func_145747_a((IChatComponent)notification);
                player.func_71028_bD();
            } else {
                ChatComponentTranslation notification = new ChatComponentTranslation("item.visualprospecting.prospectorslog.reading.begin", new Object[0]);
                notification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                notification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                player.func_145747_a((IChatComponent)notification);
                TaskManager.instance.addTask(new SnapshotDownloadTask(authorUuid, (EntityPlayerMP)player));
            }
        }
        return item;
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> infoList, boolean ignored) {
        if (this.isFilledLog(item)) {
            NBTTagCompound compound = item.func_77978_p();
            infoList.add(I18n.func_135052_a((String)"item.visualprospecting.prospectorslog.author", (Object[])new Object[]{compound.func_74779_i("log_author")}));
        } else {
            infoList.add(I18n.func_135052_a((String)"item.visualprospecting.prospectorslog.empty", (Object[])new Object[0]));
        }
    }

    private boolean isFilledLog(ItemStack item) {
        NBTTagCompound compound = item.func_77978_p();
        return compound != null && compound.func_74764_b("log_author") && compound.func_74764_b("log_author_id");
    }
}

