/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileMill;
import forestry.factory.inventory.InventoryRainmaker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileMillRainmaker
extends TileMill {
    private int duration;
    private boolean reverse;

    public TileMillRainmaker() {
        super(null);
        this.speed = 0.01f;
        this.setInternalInventory(new InventoryRainmaker(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_71071_by.func_70448_g() == null) {
            return;
        }
        if (FuelManager.rainSubstrate.containsKey(player.field_71071_by.func_70448_g()) && this.charge == 0) {
            RainSubstrate substrate = FuelManager.rainSubstrate.get(player.field_71071_by.func_70448_g());
            if (substrate.item.func_77969_a(player.field_71071_by.func_70448_g())) {
                this.addCharge(substrate);
                --player.field_71071_by.func_70448_g().field_77994_a;
            }
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.charge = nbttagcompound.func_74762_e("Charge");
        this.progress = nbttagcompound.func_74760_g("Progress");
        this.stage = nbttagcompound.func_74762_e("Stage");
        this.duration = nbttagcompound.func_74762_e("Duration");
        this.reverse = nbttagcompound.func_74767_n("Reverse");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("Charge", this.charge);
        nbttagcompound.func_74776_a("Progress", this.progress);
        nbttagcompound.func_74768_a("Stage", this.stage);
        nbttagcompound.func_74768_a("Duration", this.duration);
        nbttagcompound.func_74757_a("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
        this.sendNetworkUpdate();
    }

    @Override
    public void activate() {
        if (Proxies.render.hasRendering()) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ambient.weather.thunder", 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.field_145851_c + 0.5f;
            float f1 = (float)this.field_145848_d + 0.0f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.field_145849_e + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f - f3, f1, f2 + f4);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f3, f1, f2 + f4);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 - f3);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 + f3);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.reverse) {
                this.field_145850_b.func_72912_H().func_76084_b(false);
            } else {
                this.field_145850_b.func_72912_H().func_76084_b(true);
                this.field_145850_b.func_72912_H().func_76080_g(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return null;
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return null;
    }
}

