/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.WorldProviderTwilightForest;

public class TFTickHandler {
    private final Item portalItem;

    public TFTickHandler(Item portalItemIn) {
        this.portalItem = portalItemIn;
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && world.func_72820_D() % 20L == 0L && world.func_82736_K().func_82766_b("tfEnforcedProgression") && world.field_73011_w instanceof WorldProviderTwilightForest && !player.field_71075_bZ.field_75098_d) {
            this.checkBiomeForProgression(player, world);
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && world.func_72820_D() % 100L == 0L && world.func_82736_K().func_82766_b("tfEnforcedProgression") && world.field_73011_w instanceof WorldProviderTwilightForest) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.checkForLockedStructuresSendPacket(player, world);
            } else {
                this.sendAllClearPacket(world, player);
            }
        }
    }

    private void sendStructureProtectionPacket(World world, EntityPlayer player, StructureBoundingBox sbb) {
        FMLProxyPacket message = TFGenericPacketHandler.makeStructureProtectionPacket(sbb);
        if (player instanceof EntityPlayerMP) {
            TwilightForestMod.genericChannel.sendTo(message, (EntityPlayerMP)player);
        }
    }

    private void sendAllClearPacket(World world, EntityPlayer player) {
        FMLProxyPacket message = TFGenericPacketHandler.makeStructureProtectionClearPacket();
        if (player instanceof EntityPlayerMP) {
            TwilightForestMod.genericChannel.sendTo(message, (EntityPlayerMP)player);
        }
    }

    private boolean checkForLockedStructuresSendPacket(EntityPlayer player, World world) {
        ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)world.field_73011_w).getChunkProvider();
        int px = MathHelper.func_76128_c((double)player.field_70165_t);
        int py = MathHelper.func_76128_c((double)player.field_70163_u);
        int pz = MathHelper.func_76128_c((double)player.field_70161_v);
        if (chunkProvider != null && chunkProvider.isBlockNearFullStructure(px, pz, 100)) {
            StructureBoundingBox fullSBB = chunkProvider.getFullSBBNear(px, pz, 100);
            TFFeature nearFeature = TFFeature.getFeatureForRegion(fullSBB.func_78881_e() >> 4, fullSBB.func_78891_g() >> 4, world);
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAchievement(player)) {
                this.sendAllClearPacket(world, player);
                return false;
            }
            this.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }
        return false;
    }

    private void checkBiomeForProgression(EntityPlayer player, World world) {
        BiomeGenBase currentBiome = world.func_72807_a(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
        if (currentBiome instanceof TFBiomeBase) {
            boolean dangerousBiome;
            TFBiomeBase tfBiome = (TFBiomeBase)currentBiome;
            boolean bl = dangerousBiome = !tfBiome.doesPlayerHaveRequiredAchievement(player);
            if (dangerousBiome) {
                tfBiome.enforceProgession(player, world);
            }
        }
    }

    @SubscribeEvent
    public void onItemDroppedByPlayer(ItemTossEvent event) {
        if (!TwilightForestMod.disablePortalCreation && !event.isCanceled() && this.portalItem != null && event.entityItem.func_92059_d().func_77973_b() == this.portalItem) {
            if (TwilightForestMod.adminOnlyPortals && !MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(event.player.func_146103_bH())) {
                return;
            }
            event.player.func_71012_a((EntityItem)new PortalEntityItem(event.entityItem, event.player));
            event.setCanceled(true);
        }
    }

    private static class PortalEntityItem
    extends EntityItem {
        private final UUID uuidPlayerWhoDroppedThis;

        public PortalEntityItem(EntityItem entityItemToReplace, EntityPlayer player) {
            super(entityItemToReplace.field_70170_p, entityItemToReplace.field_70165_t, entityItemToReplace.field_70163_u, entityItemToReplace.field_70161_v, entityItemToReplace.func_92059_d());
            this.field_145804_b = entityItemToReplace.field_145804_b;
            this.field_70159_w = entityItemToReplace.field_70159_w;
            this.field_70181_x = entityItemToReplace.field_70181_x;
            this.field_70179_y = entityItemToReplace.field_70179_y;
            this.uuidPlayerWhoDroppedThis = player.func_110124_au();
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && (this.field_70170_p.field_73011_w.field_76574_g == 0 || this.field_70170_p.field_73011_w.field_76574_g == TwilightForestMod.dimensionID || TwilightForestMod.allowPortalsInOtherDimensions) && this.field_70170_p.func_72875_a(this.field_70121_D, Material.field_151586_h)) {
                int dz;
                int dy;
                Random rand = new Random();
                for (int k = 0; k < 2; ++k) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.field_70170_p.func_72869_a("spell", this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, d, d1, d2);
                }
                int dx = MathHelper.func_76128_c((double)this.field_70165_t);
                if (((BlockTFPortal)TFBlocks.portal).tryToCreatePortal(this.field_70170_p, dx, dy = MathHelper.func_76128_c((double)this.field_70163_u), dz = MathHelper.func_76128_c((double)this.field_70161_v))) {
                    EntityPlayer player = this.field_70170_p.func_152378_a(this.uuidPlayerWhoDroppedThis);
                    if (player != null) {
                        player.func_71029_a((StatBase)TFAchievementPage.twilightPortal);
                    }
                    this.func_70106_y();
                }
            }
            super.func_70071_h_();
        }
    }
}

