/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import twilightforest.TFFeature;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class CommandTFFeature
extends CommandBase {
    public String func_71517_b() {
        return "tffeature";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tffeature accepts the following arguments: info";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length <= 0) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
        if (args[0].equalsIgnoreCase("info")) {
            EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
            int dx = MathHelper.func_76128_c((double)player.field_70165_t);
            int dy = MathHelper.func_76128_c((double)player.field_70163_u);
            int dz = MathHelper.func_76128_c((double)player.field_70161_v);
            if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
                throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
            }
            TFFeature nearbyFeature = ((TFWorldChunkManager)player.field_70170_p.field_73011_w.field_76578_c).getFeatureAt(dx, dz, player.field_70170_p);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("The nearest feature is %s", new Object[]{nearbyFeature.name}));
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)player.field_70170_p.field_73011_w).getChunkProvider();
            if (chunkProvider.isBlockInStructureBB(dx, dy, dz)) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("You are in the structure for that feature.", new Object[0]));
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Structure conquer flag = %s.", new Object[]{chunkProvider.isStructureConquered(dx, dy, dz)}));
                return;
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("You are not in the structure for that feature.", new Object[0]));
            }
            return;
        } else if (args[0].equalsIgnoreCase("reactivate")) {
            this.changeStructureActivity(sender, false);
            return;
        } else if (args[0].equalsIgnoreCase("conquer")) {
            this.changeStructureActivity(sender, true);
            return;
        } else {
            if (!args[0].equalsIgnoreCase("center")) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
            EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
            int dx = MathHelper.func_76128_c((double)player.field_70165_t);
            int dz = MathHelper.func_76128_c((double)player.field_70161_v);
            ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(dx >> 4, dz >> 4, player.field_70170_p);
            TFWorldChunkManager wcm = (TFWorldChunkManager)player.field_70170_p.field_73011_w.field_76578_c;
            boolean fc = wcm.isInFeatureChunk(player.field_70170_p, dx, dz);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Center of feature = %s.", new Object[]{cc}));
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Are in feature chunk = %s.", new Object[]{fc}));
        }
    }

    private void changeStructureActivity(ICommandSender sender, boolean flag) throws WrongUsageException {
        EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
        int dx = MathHelper.func_76128_c((double)player.field_70165_t);
        int dy = MathHelper.func_76128_c((double)player.field_70163_u);
        int dz = MathHelper.func_76128_c((double)player.field_70161_v);
        if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
            throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
        }
        ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)player.field_70170_p.field_73011_w).getChunkProvider();
        if (chunkProvider.isBlockInStructureBB(dx, dy, dz)) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Structure conquer flag was %s.  Changing to %s.", new Object[]{chunkProvider.isStructureConquered(dx, dy, dz), flag}));
            chunkProvider.setStructureConquered(dx, dy, dz, flag);
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("You are not in a structure.", new Object[0]));
        }
    }
}

