/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BucketHandler {
    public static BucketHandler INSTANCE = new BucketHandler();
    public final Set<Fluid> allowedFluids = new HashSet<Fluid>();

    private BucketHandler() {
        this.allowedFluids.add(Fluids.CREOSOTE.get());
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target, event.current);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, MovingObjectPosition pos, ItemStack stack) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        FluidStack fluidStack = FluidHelper.drainBlock(block, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, false);
        if (fluidStack == null) {
            return null;
        }
        if (!this.allowedFluids.contains(fluidStack.getFluid())) {
            return null;
        }
        FluidItemHelper.FillReturn filled = FluidItemHelper.fillContainer(stack, fluidStack);
        if (filled.amount > 0) {
            FluidHelper.drainBlock(block, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, true);
        }
        return filled.container;
    }
}

