/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import mods.railcraft.common.util.steam.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEngineSteamHobby
extends TileEngineSteam
implements IInventory,
ISidedInventory,
INeedsFuel,
ITemperature {
    public static final byte SLOT_FUEL = 0;
    public static final byte SLOT_LIQUID_INPUT = 1;
    public static final byte SLOT_LIQUID_OUTPUT = 2;
    private static final int OUTPUT_RF = 20;
    private static final int STEAM_USED = 10;
    private static final float FUEL_PER_CONVERSION_MULTIPLIER = 1.25f;
    private static final byte TICKS_PER_BOILER_CYCLE = 20;
    private static final byte TANK_WATER = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    private static final int[] NO_SLOTS = new int[0];
    public final SteamBoiler boiler;
    private StandaloneInventory inv = new StandaloneInventory(3, this);
    private InventoryMapper invFuel = new InventoryMapper(this.inv, 0, 1);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1);
    private boolean explode = false;

    public TileEngineSteamHobby() {
        FilteredTank tankWater = new FilteredTank(4000, Fluids.WATER.get(), this);
        this.getTankManager().add(tankWater);
        this.getTankManager().get(0).setCapacity(4000);
        this.boiler = new SteamBoiler(tankWater, this.getTankManager().get(0));
        this.boiler.setTicksPerCycle(20);
        this.boiler.setEfficiencyModifier(1.25);
        this.boiler.setFuelProvider(new SolidFuelProvider(this.inv, 0){

            @Override
            public double getMoreFuel() {
                if (TileEngineSteamHobby.this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT || !TileEngineSteamHobby.this.isPowered()) {
                    return 0.0;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.ENGINE_STEAM_HOBBY;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.ENGINE_HOBBY, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() != Items.field_151133_ar && (Game.isHost(this.field_145850_b) ? FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false) : FluidItemHelper.isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public int getMaxOutputRF() {
        return 20;
    }

    @Override
    public int steamUsedPerTick() {
        return 10;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isHost(this.field_145850_b) && this.explode) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 2.0f, true);
            this.explode = false;
        }
    }

    @Override
    public void burn() {
        super.burn();
        if (this.clock % 8 == 0) {
            FluidHelper.drainContainers(this, this.inv, 1, 2);
        }
        if (StackFilter.EMPTY_BUCKET.matches(this.func_70301_a(0))) {
            InvTools.moveOneItem((IInventory)this.invFuel, (IInventory)this.invOutput, (IStackFilter)StackFilter.EMPTY_BUCKET);
        }
        this.boiler.tick(1);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }

    public String func_145825_b() {
        return this.getName();
    }

    @Override
    public int maxEnergy() {
        return 100000;
    }

    @Override
    public int maxEnergyReceived() {
        return 3000;
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.inv.func_70301_a(0);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public float getTemperature() {
        return (float)this.boiler.getHeat();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inv.writeToNBT("Items", data);
        this.boiler.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inv.readFromNBT("Items", data);
        this.boiler.readFromNBT(data);
    }

    public int[] func_94128_d(int side) {
        if (this.getOrientation().ordinal() == side) {
            return NO_SLOTS;
        }
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 1: {
                return Fluids.WATER.is(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack));
            }
        }
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPowered() && Fluids.STEAM.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        if (Fluids.WATER.is(resource)) {
            return this.fill(1, resource, doFill);
        }
        return 0;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        FluidStack water;
        if (tankIndex == 1 && this.boiler.isSuperHeated() && ((water = this.getTankManager().get(1).getFluid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return this.getTankManager().fill(tankIndex, resource, doFill);
    }

    public void explode() {
        this.explode = true;
    }
}

