/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTESRSignals;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.PostConnectionHelper;
import mods.railcraft.common.blocks.signals.BlockSignalRailcraft;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderSignal
extends RenderTESRSignals
implements ICombinedRenderer {
    private final SignalAspect defaultAspect;
    private final RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();
    private final RenderFakeBlock.RenderInfo tesrInfo = new RenderFakeBlock.RenderInfo();

    public RenderSignal(SignalAspect defaultAspect) {
        this.defaultAspect = defaultAspect;
        this.info.template = RailcraftBlocks.getBlockSignal();
        this.info.texture = new IIcon[6];
        this.tesrInfo.template = RailcraftBlocks.getBlockSignal();
        this.tesrInfo.texture = new IIcon[6];
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
        float f7;
        boolean south;
        float size;
        TileSignalBase tile = (TileSignalBase)iBlockAccess.func_147438_o(x, y, z);
        if (tile == null) {
            return;
        }
        float pix = 0.0625f;
        int facing = tile.getFacing().ordinal();
        if (facing >= this.info.texture.length) {
            facing = 0;
        }
        float min = 3.0f * pix;
        float max = 13.0f * pix;
        this.info.setBlockBounds(min, 6.0f * pix, min, max, 1.0f, max);
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalSingle[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalSingle[0];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[facing] = BlockSignalRailcraft.texturesSignalSingle[2];
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        this.info.brightness = -1;
        this.info.setRenderAllSides();
        this.info.texture[facing] = BlockSignalRailcraft.texturesSignalSingle[2];
        if (facing == 2 || facing == 3) {
            size = 13.0f * pix;
            if (facing == 2) {
                size = pix;
            }
            this.info.setBlockBounds(6.0f * pix, 13.0f * pix, size, 10.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(5.0f * pix, 10.0f * pix, size, 6.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(10.0f * pix, 10.0f * pix, size, 11.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        } else if (facing == 4 || facing == 5) {
            size = 13.0f * pix;
            if (facing == 4) {
                size = pix;
            }
            this.info.setBlockBounds(size, 13.0f * pix, 6.0f * pix, size + 2.0f * pix, 14.0f * pix, 10.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(size, 10.0f * pix, 5.0f * pix, size + 2.0f * pix, 14.0f * pix, 6.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(size, 10.0f * pix, 10.0f * pix, size + 2.0f * pix, 14.0f * pix, 11.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalSingle[3];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalSingle[3];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalSingle[4];
        min = 6.0f * pix;
        max = 10.0f * pix;
        Block below = WorldPlugin.getBlock(iBlockAccess, x, y - 1, z);
        World world = Game.getWorld();
        if (PostConnectionHelper.connect(iBlockAccess, x, y, z, ForgeDirection.DOWN) != IPostConnection.ConnectStyle.NONE || iBlockAccess.isSideSolid(x, y - 1, z, ForgeDirection.UP, true) || below != null && below.canPlaceTorchOnTop(world, x, y - 1, z)) {
            this.info.setBlockBounds(min, 0.0f, min, max, 15.0f * pix, max);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        boolean east_west = false;
        boolean north_south = false;
        boolean west = PostConnectionHelper.connect(iBlockAccess, x, y, z, ForgeDirection.WEST) != IPostConnection.ConnectStyle.NONE;
        boolean east = PostConnectionHelper.connect(iBlockAccess, x, y, z, ForgeDirection.EAST) != IPostConnection.ConnectStyle.NONE;
        boolean north = PostConnectionHelper.connect(iBlockAccess, x, y, z, ForgeDirection.NORTH) != IPostConnection.ConnectStyle.NONE;
        boolean bl = south = PostConnectionHelper.connect(iBlockAccess, x, y, z, ForgeDirection.SOUTH) != IPostConnection.ConnectStyle.NONE;
        if (east || west) {
            east_west = true;
        }
        if (north || south) {
            north_south = true;
        }
        if (!east_west && !north_south) {
            east_west = true;
        }
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 11.0f * pix;
        float f3 = 14.0f * pix;
        float f4 = west ? 0.0f : f;
        float f5 = east ? 1.0f : f1;
        float f6 = north ? 0.0f : f;
        float f8 = f7 = south ? 1.0f : f1;
        if (east_west) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (north_south) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        f2 = 5.0f * pix;
        f3 = 8.0f * pix;
        if (east_west) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (north_south) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        float pix = 0.0625f;
        float min = 6.0f * pix;
        float max = 10.0f * pix;
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalSingle[3];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalSingle[3];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalSingle[4];
        this.info.setBlockBounds(min, 0.0f, min, max, 15.0f * pix, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalSingle[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalSingle[0];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalSingle[2];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalSingle[1];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalSingle[1];
        min = 3.0f * pix;
        max = 13.0f * pix;
        this.info.setBlockBounds(min, 6.0f * pix, min, max, 1.0f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[3] = BlockSignalRailcraft.texturesLampTop[this.defaultAspect.getTextureIndex()];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalSingle[2];
        float size = 13.0f * pix;
        this.info.setBlockBounds(6.0f * pix, 13.0f * pix, size, 10.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(5.0f * pix, 10.0f * pix, size, 6.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(10.0f * pix, 10.0f * pix, size, 11.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        GL11.glPopAttrib();
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        SignalAspect aspect;
        super.func_147500_a(te, x, y, z, f);
        if (!(te instanceof TileSignalBase)) {
            return;
        }
        RenderFakeBlock.RenderInfo info = this.tesrInfo;
        TileSignalBase tile = (TileSignalBase)te;
        int facing = tile.getFacing().ordinal();
        if (facing >= info.texture.length) {
            facing = 0;
        }
        if (!(aspect = tile.getSignalAspect()).isLit()) {
            aspect = SignalAspect.OFF;
        }
        info.texture[facing] = BlockSignalRailcraft.texturesLampTop[aspect.getTextureIndex()];
        info.setRenderSingleSide(facing);
        info.brightness = aspect.getTextureBrightness();
        RenderSignal.doRenderAspect(info, tile, x, y, z);
    }
}

