/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.thaumcraftmobaspects;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;

public class ModFileCache {
    private HashMap<String, String> entityPackageToPrefix = new HashMap(5);
    public static final String UNKNOWN_CATEGORY = "unknown";
    public static final String PLAYER_CATEGORY = "unknown";
    public static final String CONFIG_FOLDER = "ThaumcraftMobAspects";
    private final File configDirectory;
    private HashMap<String, File> localPathToFile = new HashMap();

    public ModFileCache(File configDirectory) {
        this.configDirectory = configDirectory;
        this.entityPackageToPrefix.put("net.minecraft.entity.boss", "vanilla");
        this.entityPackageToPrefix.put("net.minecraft.entity.monster", "vanilla");
        this.entityPackageToPrefix.put("net.minecraft.entity.passive", "vanilla");
        this.entityPackageToPrefix.put("net.minecraft.entity.item", "vanillaitem");
        this.entityPackageToPrefix.put("net.minecraft.entity.player", "unknown");
    }

    public Optional<File> getFile(String modId) {
        modId = this.filterModIdToValidCharacters(modId);
        try {
            File modFile = this.localPathToFile.get(modId);
            if (modFile == null) {
                modFile = new File(this.configDirectory, "ThaumcraftMobAspects/" + modId + ".cfg");
                modFile.getParentFile().mkdirs();
                modFile.createNewFile();
                this.localPathToFile.put(modId, modFile);
            }
            return Optional.of((Object)modFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.absent();
        }
    }

    private String filterModIdToValidCharacters(String modId) {
        return CharMatcher.anyOf((CharSequence)"qwertyuiopasdfghjklzxcvbnm0QWERTYUIOPASDFGHJKLZXCVBNM123456789").retainFrom((CharSequence)modId);
    }

    public HashSet<String> getModIds() {
        HashSet<String> modIds = new HashSet<String>();
        for (Object object : EntityList.field_75625_b.keySet()) {
            String entityName = (String)object;
            modIds.add(this.guessModId(entityName));
        }
        modIds.add("unknown");
        return modIds;
    }

    public String guessModId(String entityName) {
        if (entityName.contains(".")) {
            return entityName.split("\\.")[0];
        }
        Class entityClass = (Class)EntityList.field_75625_b.get(entityName);
        if (entityClass == null) {
            return "unknown";
        }
        String packageNeedingId = entityClass.getName();
        if (packageNeedingId.lastIndexOf(".") != -1) {
            packageNeedingId = packageNeedingId.substring(0, packageNeedingId.lastIndexOf("."));
        }
        Set fmlNames = EntityList.field_75626_c.entrySet();
        for (Map.Entry entry : fmlNames) {
            String packageName = ((Class)entry.getKey()).getName();
            if (packageName.lastIndexOf(".") != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf("."));
            }
            if (!packageNeedingId.equals(packageName) || !((String)entry.getValue()).contains(".")) continue;
            return ((String)entry.getValue()).split("\\.")[0];
        }
        String manualPrefix = this.entityPackageToPrefix.get(packageNeedingId);
        if (manualPrefix != null) {
            return manualPrefix;
        }
        String[] currentParts = packageNeedingId.split("\\.");
        return currentParts.length > 1 ? currentParts[0] : "unknown";
    }
}

