/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.gui.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.container.Container_Grindle;
import gtPlusPlus.core.inventories.BaseInventoryGrindle;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiScreenGrindle
extends GuiContainer {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private final EntityPlayer editingPlayer;
    private final ItemStack bookObj;
    private final boolean bookIsUnsigned;
    private boolean field_146481_r;
    private boolean field_146480_s;
    private int updateCount;
    private final int bookImageWidth = 192;
    private final int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonDone;
    private GuiButton buttonSign;
    private GuiButton buttonFinalize;
    private GuiButton buttonCancel;
    private static final ResourceLocation iconLocation = new ResourceLocation(Mods.GTPlusPlus.ID, "textures/gui/itemGrindle.png");
    private final BaseInventoryGrindle inventory;

    public GuiScreenGrindle(Container_Grindle containerItem, EntityPlayer player) {
        super((Container)containerItem);
        this.inventory = containerItem.inventory;
        this.editingPlayer = player;
        this.bookObj = this.inventory.func_70301_a(0);
        boolean bl = this.bookIsUnsigned = this.bookObj == null;
        if (this.bookObj != null) {
            if (this.bookObj.func_77942_o()) {
                NBTTagCompound nbttagcompound = this.bookObj.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("pages", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c();
                    if (this.bookTotalPages < 1) {
                        this.bookTotalPages = 1;
                    }
                }
            }
            if (this.bookPages == null && this.bookIsUnsigned) {
                this.bookPages = new NBTTagList();
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookTotalPages = 1;
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.bookIsUnsigned) {
            int n = this.field_146294_l / 2 - 100;
            Objects.requireNonNull(this);
            this.buttonSign = new GuiButton(3, n, 4 + 192, 98, 20, I18n.func_135052_a((String)"book.signButton", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonSign);
            int n2 = this.field_146294_l / 2 + 2;
            Objects.requireNonNull(this);
            this.buttonDone = new GuiButton(0, n2, 192 - 4, 98, 20, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
            int n3 = this.field_146294_l / 2 - 100;
            Objects.requireNonNull(this);
            this.buttonFinalize = new GuiButton(5, n3, 4 + 192, 98, 20, I18n.func_135052_a((String)"book.finalizeButton", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonFinalize);
            int n4 = this.field_146294_l / 2 + 2;
            Objects.requireNonNull(this);
            this.buttonCancel = new GuiButton(4, n4, 4 + 192, 98, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonCancel);
        } else {
            int n = this.field_146294_l / 2 - 100;
            Objects.requireNonNull(this);
            this.buttonDone = new GuiButton(0, n, 192 + 100, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
        }
        Objects.requireNonNull(this);
        int i = (this.field_146294_l - 192) / 2;
        int b0 = 2;
        this.buttonNextPage = new NextPageButton(1, i + 120, 156, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38, 156, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = !this.field_146480_s && (this.currPage < this.bookTotalPages - 1 || this.bookIsUnsigned);
        this.buttonPreviousPage.field_146125_m = !this.field_146480_s && this.currPage > 0;
        boolean bl = this.buttonDone.field_146125_m = !this.bookIsUnsigned || !this.field_146480_s;
        if (this.bookIsUnsigned) {
            this.buttonSign.field_146125_m = !this.field_146480_s;
            this.buttonCancel.field_146125_m = this.field_146480_s;
            this.buttonFinalize.field_146125_m = this.field_146480_s;
            this.buttonFinalize.field_146124_l = this.bookTitle.trim().length() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBookToServer(boolean p_146462_1_) {
        if (this.bookIsUnsigned && this.field_146481_r && this.bookPages != null) {
            String s;
            while (this.bookPages.func_74745_c() > 1 && (s = this.bookPages.func_150307_f(this.bookPages.func_74745_c() - 1)).length() == 0) {
                this.bookPages.func_74744_a(this.bookPages.func_74745_c() - 1);
            }
            if (this.bookObj.func_77942_o()) {
                NBTTagCompound nbttagcompound = this.bookObj.func_77978_p();
                nbttagcompound.func_74782_a("pages", (NBTBase)this.bookPages);
            } else {
                this.bookObj.func_77983_a("pages", (NBTBase)this.bookPages);
            }
            s = "MC|BEdit";
            if (p_146462_1_) {
                s = "MC|BSign";
                this.bookObj.func_77983_a("author", (NBTBase)new NBTTagString(this.editingPlayer.func_70005_c_()));
                this.bookObj.func_77983_a("title", (NBTBase)new NBTTagString(this.bookTitle.trim()));
                this.bookObj.func_150996_a(ModItems.itemGrindleTablet);
            }
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                new PacketBuffer(bytebuf).func_150788_a(this.bookObj);
                this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload(s, bytebuf));
            }
            catch (Exception exception) {
                logger.error("Couldn't send book info", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.sendBookToServer(false);
            } else if (button.field_146127_k == 3 && this.bookIsUnsigned) {
                this.field_146480_s = true;
            } else if (button.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.bookIsUnsigned) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
            } else if (button.field_146127_k == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                }
            } else if (button.field_146127_k == 5 && this.field_146480_s) {
                this.sendBookToServer(true);
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 4 && this.field_146480_s) {
                this.field_146480_s = false;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++this.bookTotalPages;
            this.field_146481_r = true;
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        super.func_73869_a(p_73869_1_, p_73869_2_);
        if (this.bookIsUnsigned) {
            if (this.field_146480_s) {
                this.func_146460_c(p_73869_1_, p_73869_2_);
            } else {
                this.keyTypedInBook(p_73869_1_, p_73869_2_);
            }
        }
    }

    private void keyTypedInBook(char p_146463_1_, int p_146463_2_) {
        switch (p_146463_1_) {
            case '\u0016': {
                this.func_146459_b(GuiScreen.func_146277_j());
                return;
            }
        }
        switch (p_146463_2_) {
            case 14: {
                String s = this.func_146456_p();
                if (s.length() > 0) {
                    this.func_146457_a(s.substring(0, s.length() - 1));
                }
                return;
            }
            case 28: 
            case 156: {
                this.func_146459_b("\n");
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)p_146463_1_)) {
            this.func_146459_b(Character.toString(p_146463_1_));
        }
    }

    private void func_146460_c(char p_146460_1_, int p_146460_2_) {
        switch (p_146460_2_) {
            case 14: {
                if (!this.bookTitle.isEmpty()) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: 
            case 156: {
                if (!this.bookTitle.isEmpty()) {
                    this.sendBookToServer(true);
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.func_71566_a((char)p_146460_1_)) {
            this.bookTitle = this.bookTitle + Character.toString(p_146460_1_);
            this.updateButtons();
            this.field_146481_r = true;
        }
    }

    private String func_146456_p() {
        return this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c() ? this.bookPages.func_150307_f(this.currPage) : "";
    }

    private void func_146457_a(String p_146457_1_) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            this.bookPages.func_150304_a(this.currPage, (NBTBase)new NBTTagString(p_146457_1_));
            this.field_146481_r = true;
        }
    }

    private void func_146459_b(String p_146459_1_) {
        String s1 = this.func_146456_p();
        String s2 = s1 + p_146459_1_;
        int i = this.field_146289_q.func_78267_b(s2 + "" + EnumChatFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.func_146457_a(s2);
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(iconLocation);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l2 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l2, 0, 0, this.field_146999_f, this.field_147000_g);
        int b0 = 2;
        if (this.inventory.func_70301_a(0) != null) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)("" + NBTUtils.getBookTitle(this.inventory.func_70301_a(0))), (Object[])new Object[0]), 10, 8, Utils.rgbtoHexValue(125, 255, 125));
        }
        if (this.field_146480_s) {
            String s = this.bookTitle;
            if (this.bookIsUnsigned) {
                s = this.updateCount / 6 % 2 == 0 ? s + "" + EnumChatFormatting.BLACK + "_" : s + "" + EnumChatFormatting.GRAY + "_";
            }
            String s1 = I18n.func_135052_a((String)"book.editTitle", (Object[])new Object[0]);
            int l = this.field_146289_q.func_78256_a(s1);
            this.field_146289_q.func_78276_b(s1, k + 36 + (116 - l) / 2, 34, 0);
            int i1 = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, k + 36 + (116 - i1) / 2, 50, 0);
            String s2 = I18n.func_135052_a((String)"book.byAuthor", (Object[])new Object[]{this.editingPlayer.func_70005_c_()});
            int j1 = this.field_146289_q.func_78256_a(s2);
            this.field_146289_q.func_78276_b(EnumChatFormatting.DARK_GRAY + s2, k + 36 + (116 - j1) / 2, 60, 0);
            String s3 = I18n.func_135052_a((String)"book.finalizeWarning", (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(s3, k + 36, 82, 116, 0);
        } else {
            String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s1 = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
                s1 = this.bookPages.func_150307_f(this.currPage);
            }
            if (this.bookIsUnsigned) {
                s1 = this.field_146289_q.func_78260_a() ? s1 + "_" : (this.updateCount / 6 % 2 == 0 ? s1 + "" + EnumChatFormatting.BLACK + "_" : s1 + "" + EnumChatFormatting.GRAY + "_");
            }
            int l = this.field_146289_q.func_78256_a(s);
            Objects.requireNonNull(this);
            this.field_146289_q.func_78276_b(s, k - l + 192 - 44, 18, 0);
            this.field_146289_q.func_78279_b(s1, k + 36, 34, 116, 0);
        }
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(iconLocation);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;

        public NextPageButton(int p_i1079_1_, int p_i1079_2_, int p_i1079_3_, boolean p_i1079_4_) {
            super(p_i1079_1_, p_i1079_2_, p_i1079_3_, 23, 13, "");
            this.field_146151_o = p_i1079_4_;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

