/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.common.container.slot.ContainerControl;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.premade.SubContainerControl;
import com.creativemd.creativecore.common.gui.premade.SubGuiControl;
import javax.vecmath.Vector4d;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiScrollBox
extends GuiControl {
    public SubGuiControl gui = new SubGuiControl(this);
    public SubContainerControl container;
    public int maxScroll = 0;
    public int scrolled = 0;
    public boolean dragged;

    public GuiScrollBox(String name, EntityPlayer player, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.gui.initGui();
        this.gui.width = width;
        this.gui.height = height;
        this.container = new SubContainerControl(player);
        this.container.initContainer();
        this.gui.container = this.container;
    }

    public void addControl(ContainerControl control) {
        this.container.controls.add(control);
        control.parent = this.container;
        control.setID(this.container.controls.size());
        control.init();
        this.addControl(control.guiControl);
    }

    public void addControl(GuiControl control) {
        this.gui.controls.add(control);
        control.parent = this.gui;
        control.resetID();
        control.setID(this.gui.controls.size());
        int tempHeight = control.posY + control.height / 2 + 10 - this.height;
        if (tempHeight > this.maxScroll) {
            this.maxScroll = tempHeight;
        }
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        this.gui.onTick();
        Vector4d black = new Vector4d(0.0, 0.0, 0.0, 255.0);
        RenderHelper2D.drawGradientRect(0, 0, this.width, this.height, black, black);
        Vector4d color = new Vector4d(140.0, 140.0, 140.0, 255.0);
        RenderHelper2D.drawGradientRect(1, 1, this.width - 1, this.height - 1, color, color);
        ScaledResolution scaledresolution = new ScaledResolution(mc, GuiScrollBox.mc.field_71443_c, GuiScrollBox.mc.field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int movex = i / 2 - this.parent.width / 2 + this.posX + 1;
        int movey = j / 2 - this.parent.height / 2 + (this.parent.height - (this.height + this.posY)) + 1;
        if (this.parent instanceof SubGuiControl) {
            movey = j / 2 - ((SubGuiControl)this.parent).parent.parent.height / 2 + (((SubGuiControl)this.parent).parent.parent.height - (this.height + this.posY)) + 1;
        }
        int scale = scaledresolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(movex *= scale), (int)(movey *= scale), (int)((this.width - 2) * scale), (int)((this.height - 2) * scale));
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-this.scrolled), (double)0.0);
        this.gui.renderControls(renderer);
        this.gui.drawOverlay(renderer);
        GL11.glDisable((int)3089);
        if (this.isMouseOver()) {
            boolean oneTop = true;
            for (int k = 0; k < this.parent.controls.size() && this.parent.controls.get(k) != this; ++k) {
                if (!this.parent.controls.get(k).isMouseOver()) continue;
                oneTop = false;
                break;
            }
            if (oneTop) {
                this.gui.renderTooltip(renderer);
            }
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        color = new Vector4d(130.0, 130.0, 130.0, 255.0);
        RenderHelper2D.drawGradientRect(this.width - 15, 1, this.width - 1, this.height - 1, color, color);
        RenderHelper2D.renderScrollBar(this.width - 15, 1, this.maxScroll == 0 ? 0.0 : (double)this.scrolled / (double)this.maxScroll, this.height - 2, this.maxScroll <= 0);
    }

    public void onScrolled() {
        if (this.scrolled < 0) {
            this.scrolled = 0;
        }
        if (this.scrolled > this.maxScroll) {
            this.scrolled = this.maxScroll;
        }
        this.gui.scrolled = this.scrolled;
    }

    @Override
    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        if (!this.gui.mouseScrolled(posX, posY, scrolled)) {
            this.scrolled -= scrolled * 30;
        }
        this.onScrolled();
        return true;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        this.gui.mousePressed(posX, posY, button);
        return true;
    }

    @Override
    public boolean mouseDragged(int posX, int posY, int button, long time) {
        this.gui.mouseDragged(posX, posY, button, time);
        if (this.width - posX <= 14) {
            this.dragged = true;
        }
        return true;
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        this.gui.mouseReleased(posX, posY, button);
        this.dragged = false;
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        this.gui.mouseMove(posX, posY, button);
        if (this.dragged) {
            double percent = (double)(posY - this.posY) / (double)this.height;
            this.scrolled = (int)(percent * (double)this.maxScroll);
            this.onScrolled();
        }
    }

    @Override
    public void onGuiClose() {
        this.gui.onGuiClose();
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        return this.gui.keyTyped(character, key);
    }
}

