/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_CraftingInput_ME;
import gregtech.common.tileentities.machines.IDualInputHatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_CraftingInput_Slave
extends GT_MetaTileEntity_Hatch_InputBus
implements IDualInputHatch {
    private GT_MetaTileEntity_Hatch_CraftingInput_ME master;
    private int masterX;
    private int masterY;
    private int masterZ;
    private boolean masterSet = false;

    public GT_MetaTileEntity_Hatch_CraftingInput_Slave(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6, 0, new String[]{"Slave for Crafting Input Buffer", "Link with Crafting Input Buffer using Data Stick to share inventory", "Left click on the Crafting Input Buffer, then right click on this block to link them"});
        this.disableSort = true;
    }

    public GT_MetaTileEntity_Hatch_CraftingInput_Slave(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.disableSort = true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_CraftingInput_Slave(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_SLAVE)};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (aTimer % 100L == 0L && this.masterSet && this.getMaster() == null) {
            this.trySetMasterFromCoord(this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("master")) {
            NBTTagCompound masterNBT = aNBT.func_74775_l("master");
            this.masterX = masterNBT.func_74762_e("x");
            this.masterY = masterNBT.func_74762_e("y");
            this.masterZ = masterNBT.func_74762_e("z");
            this.masterSet = true;
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.masterSet) {
            NBTTagCompound masterNBT = new NBTTagCompound();
            masterNBT.func_74768_a("x", this.masterX);
            masterNBT.func_74768_a("y", this.masterY);
            masterNBT.func_74768_a("z", this.masterZ);
            aNBT.func_74782_a("master", (NBTBase)masterNBT);
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.getMaster() != null) {
            ret.add("This bus is linked to the Crafting Input Buffer at " + this.masterX + ", " + this.masterY + ", " + this.masterZ + ".");
            ret.addAll(Arrays.asList(this.getMaster().getInfoData()));
        } else {
            ret.add("This bus is not linked to any Crafting Input Buffer.");
        }
        return ret.toArray(new String[0]);
    }

    public GT_MetaTileEntity_Hatch_CraftingInput_ME getMaster() {
        if (this.master == null) {
            return null;
        }
        if (this.master.getBaseMetaTileEntity() == null) {
            this.master = null;
        }
        return this.master;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public Iterator<GT_MetaTileEntity_Hatch_CraftingInput_ME.PatternSlot> inventories() {
        return this.getMaster() != null ? this.getMaster().inventories() : Collections.emptyIterator();
    }

    @Override
    public boolean justUpdated() {
        return this.getMaster() != null && this.getMaster().justUpdated();
    }

    public GT_MetaTileEntity_Hatch_CraftingInput_ME trySetMasterFromCoord(int x, int y, int z) {
        TileEntity tileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
        if (tileEntity == null) {
            return null;
        }
        if (!(tileEntity instanceof IGregTechTileEntity)) {
            return null;
        }
        IGregTechTileEntity gtTileEntity = (IGregTechTileEntity)tileEntity;
        IMetaTileEntity metaTileEntity = gtTileEntity.getMetaTileEntity();
        if (!(metaTileEntity instanceof GT_MetaTileEntity_Hatch_CraftingInput_ME)) {
            return null;
        }
        this.masterX = x;
        this.masterY = y;
        this.masterZ = z;
        this.masterSet = true;
        this.master = (GT_MetaTileEntity_Hatch_CraftingInput_ME)metaTileEntity;
        return this.master;
    }

    private boolean tryLinkDataStick(EntityPlayer aPlayer) {
        int z;
        int y;
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return false;
        }
        if (!dataStick.func_77942_o() || !dataStick.field_77990_d.func_74779_i("type").equals("CraftingInputBuffer")) {
            return false;
        }
        NBTTagCompound nbt = dataStick.field_77990_d;
        int x = nbt.func_74762_e("x");
        if (this.trySetMasterFromCoord(x, y = nbt.func_74762_e("y"), z = nbt.func_74762_e("z")) != null) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Link successful"));
            return true;
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Link failed"));
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return false;
        }
        if (this.tryLinkDataStick(aPlayer)) {
            return true;
        }
        GT_MetaTileEntity_Hatch_CraftingInput_ME master = this.getMaster();
        if (master != null) {
            return master.onRightclick(master.getBaseMetaTileEntity(), aPlayer);
        }
        return false;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(tag.func_74767_n("linked") ? "Linked" : "Not linked");
        if (tag.func_74764_b("masterX")) {
            currenttip.add("Bound to " + tag.func_74762_e("masterX") + ", " + tag.func_74762_e("masterY") + ", " + tag.func_74762_e("masterZ"));
        }
        if (tag.func_74764_b("masterName")) {
            currenttip.add(EnumChatFormatting.GOLD + tag.func_74779_i("masterName") + EnumChatFormatting.RESET);
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74757_a("linked", this.getMaster() != null);
        if (this.masterSet) {
            tag.func_74768_a("masterX", this.masterX);
            tag.func_74768_a("masterY", this.masterY);
            tag.func_74768_a("masterZ", this.masterZ);
        }
        if (this.getMaster() != null) {
            tag.func_74778_a("masterName", this.getMaster().getName());
        }
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }
}

