/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.waila;

import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.ai.AIRobotShutdown;
import buildcraft.robotics.ai.AIRobotSleep;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class EntityRobotDataProvider
implements IWailaEntityProvider {
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        currenttip.clear();
        EntityRobot robot = (EntityRobot)entity;
        int energy = robot.getEnergy();
        int pct = energy * 100 / 100000;
        String enInfo = pct + "% Charged";
        if (energy == 0) {
            enInfo = "No Charge";
        }
        enInfo = (pct >= 80 ? EnumChatFormatting.GREEN : (pct >= 50 ? EnumChatFormatting.YELLOW : (pct >= 30 ? EnumChatFormatting.GOLD : (pct >= 20 ? EnumChatFormatting.RED : EnumChatFormatting.DARK_RED)))) + enInfo;
        currenttip.add(enInfo);
        try {
            if (accessor != null && accessor.getNBTData() != null) {
                if (accessor.getNBTData().func_74767_n("r_sleep")) {
                    currenttip.add(EnumChatFormatting.ITALIC + "Inactive");
                } else if (accessor.getNBTData().func_74767_n("r_shutdown")) {
                    currenttip.add(EnumChatFormatting.ITALIC + "Dead");
                } else if (accessor.getNBTData().func_74767_n("r_invalid")) {
                    currenttip.add(EnumChatFormatting.ITALIC + "Invalid");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currenttip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        if (ent != null && ent instanceof EntityRobot) {
            if (((EntityRobot)ent).mainAI != null) {
                tag.func_74757_a("r_sleep", ((EntityRobot)ent).mainAI.getActiveAI() instanceof AIRobotSleep);
                tag.func_74757_a("r_shutdown", ((EntityRobot)ent).mainAI.getActiveAI() instanceof AIRobotShutdown);
            } else {
                tag.func_74757_a("r_invalid", true);
            }
        }
        return tag;
    }
}

