/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class ItemStackRenderer {
    private RenderManager renderManager;
    private RenderBlocks renderBlocks;
    private RenderItem renderItem;
    private TextureManager texManager;
    private FontRenderer fontRenderer;
    private ItemStack itemstack;
    private int posX;
    private int posY;
    private float zLevel;
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private DisplayAmount displayAmount;
    private boolean renderEffects;
    private boolean ignoreDepth;
    private boolean renderInColor;
    private EntityItem entityitem;
    private World worldObj;
    private float partialTickTime;

    public ItemStackRenderer(int posX, int posY, float zLevel, boolean renderEffects, boolean ignoreDepth, boolean renderInColor) {
        this.posX = posX;
        this.posY = posY;
        this.zLevel = zLevel;
        this.renderEffects = renderEffects;
        this.ignoreDepth = ignoreDepth;
        this.renderInColor = renderInColor;
        this.renderManager = RenderManager.field_78727_a;
        this.fontRenderer = this.renderManager.func_78716_a();
        if (this.fontRenderer == null) {
            this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        this.worldObj = this.renderManager.field_78722_g;
        this.texManager = this.renderManager.field_78724_e;
        if (this.texManager == null) {
            this.texManager = Minecraft.func_71410_x().func_110434_K();
        }
        this.renderBlocks = RenderBlocks.getInstance();
        this.renderItem = RenderItem.getInstance();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount) {
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, zLevel, displayAmount, true, true, false);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount, boolean renderInColor, boolean renderEffect, boolean ignoreDepth) {
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer(0, 0, zLevel, renderEffect, ignoreDepth, renderInColor);
        itemStackRenderer.setDisplayAmount(displayAmount);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, itemStackRenderer);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, ItemStackRenderer itemStackRenderer) {
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack identifierStack : _allItems) {
            if (identifierStack == null) {
                if (++column >= columns) {
                    ++row;
                    column = 0;
                }
                ++ppi;
                continue;
            }
            ItemIdentifier item = identifierStack.getItem();
            if (IItemSearch2 != null && !IItemSearch2.itemSearched(item) || ++ppi <= items * page || ppi > items * (page + 1)) continue;
            ItemStack itemstack = identifierStack.unsafeMakeNormalStack();
            int x = left + xSize * column;
            int y = top + ySize * row + 1;
            if (itemstack != null) {
                itemStackRenderer.setItemstack(itemstack).setPosX(x).setPosY(y);
                itemStackRenderer.renderInGui();
            }
            if (++column < columns) continue;
            ++row;
            column = 0;
        }
    }

    public void renderInGui() {
        assert (this.itemstack != null);
        assert (this.displayAmount != null);
        assert (this.renderBlocks != null);
        assert (this.renderItem != null);
        assert (this.texManager != null);
        assert (this.fontRenderer != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2977);
        GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)this.renderBlocks, (TextureManager)this.texManager, (ItemStack)this.itemstack, (boolean)this.renderInColor, (float)this.zLevel, (float)this.posX, (float)this.posY)) {
            this.renderItem.field_77023_b += this.zLevel;
            this.renderItem.renderItemIntoGUI(this.fontRenderer, this.texManager, this.itemstack, this.posX, this.posY, this.renderEffects);
            this.renderItem.field_77023_b -= this.zLevel;
        }
        RenderHelper.func_74518_a();
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        GuiGraphics.drawDurabilityBar(this.itemstack, this.posX, this.posY, this.zLevel + 20.0f);
        if (this.displayAmount != DisplayAmount.NEVER) {
            if (this.ignoreDepth) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            FontRenderer specialFontRenderer = this.itemstack.func_77973_b().getFontRenderer(this.itemstack);
            if (specialFontRenderer != null) {
                this.fontRenderer = specialFontRenderer;
            }
            GL11.glDisable((int)2896);
            String amountString = StringUtils.getFormatedStackSize(this.itemstack.field_77994_a, this.displayAmount == DisplayAmount.ALWAYS);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zLevel + 40.0f));
            SimpleGraphics.drawStringWithTranslatedShadow(this.fontRenderer, amountString, this.posX + 17 - this.fontRenderer.func_78256_a(amountString), this.posY + 9, Color.getValue(Color.WHITE));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-(this.zLevel + 40.0f)));
        }
        GL11.glPopAttrib();
    }

    public void renderInWorld() {
        Item item;
        boolean changeColor;
        assert (this.renderManager != null);
        assert (this.renderItem != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        if (this.entityitem == null || !ItemStack.func_77989_b((ItemStack)this.entityitem.func_92059_d(), (ItemStack)this.itemstack)) {
            if (this.itemstack == null) {
                throw new RuntimeException("No EntityItem and no ItemStack, I do not know what to render!");
            }
            if (this.worldObj == null) {
                throw new NullPointerException("World object is null");
            }
            this.entityitem = new EntityItem(this.worldObj, 0.0, 0.0, 0.0, this.itemstack);
            this.entityitem.func_92059_d().field_77994_a = 1;
            this.entityitem.field_70290_d = 0.0f;
        }
        boolean bl = changeColor = this.renderItem.field_77024_a != this.renderInColor;
        if (changeColor) {
            this.renderItem.field_77024_a = this.renderInColor;
        }
        if ((item = this.itemstack.func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)item).field_150939_a;
            if (block instanceof BlockPane) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (item == LogisticsPipes.logisticsRequestTable) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        this.renderManager.func_147940_a((Entity)this.entityitem, (double)this.posX, (double)this.posY, (double)this.zLevel, 0.0f, this.partialTickTime);
        if (changeColor) {
            this.renderItem.field_77024_a = !this.renderInColor;
        }
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public RenderBlocks getRenderBlocks() {
        return this.renderBlocks;
    }

    public RenderItem getRenderItem() {
        return this.renderItem;
    }

    public TextureManager getTexManager() {
        return this.texManager;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public ItemStack getItemstack() {
        return this.itemstack;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public DisplayAmount getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean isRenderEffects() {
        return this.renderEffects;
    }

    public boolean isIgnoreDepth() {
        return this.ignoreDepth;
    }

    public boolean isRenderInColor() {
        return this.renderInColor;
    }

    public EntityItem getEntityitem() {
        return this.entityitem;
    }

    public World getWorldObj() {
        return this.worldObj;
    }

    public float getPartialTickTime() {
        return this.partialTickTime;
    }

    public ItemStackRenderer setRenderManager(RenderManager renderManager) {
        this.renderManager = renderManager;
        return this;
    }

    public ItemStackRenderer setRenderBlocks(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
        return this;
    }

    public ItemStackRenderer setRenderItem(RenderItem renderItem) {
        this.renderItem = renderItem;
        return this;
    }

    public ItemStackRenderer setTexManager(TextureManager texManager) {
        this.texManager = texManager;
        return this;
    }

    public ItemStackRenderer setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        return this;
    }

    public ItemStackRenderer setItemstack(ItemStack itemstack) {
        this.itemstack = itemstack;
        return this;
    }

    public ItemStackRenderer setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public ItemStackRenderer setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public ItemStackRenderer setZLevel(float zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public ItemStackRenderer setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public ItemStackRenderer setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public ItemStackRenderer setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
        return this;
    }

    public ItemStackRenderer setDisplayAmount(DisplayAmount displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public ItemStackRenderer setRenderEffects(boolean renderEffects) {
        this.renderEffects = renderEffects;
        return this;
    }

    public ItemStackRenderer setIgnoreDepth(boolean ignoreDepth) {
        this.ignoreDepth = ignoreDepth;
        return this;
    }

    public ItemStackRenderer setRenderInColor(boolean renderInColor) {
        this.renderInColor = renderInColor;
        return this;
    }

    public ItemStackRenderer setEntityitem(EntityItem entityitem) {
        this.entityitem = entityitem;
        return this;
    }

    public ItemStackRenderer setWorldObj(World worldObj) {
        this.worldObj = worldObj;
        return this;
    }

    public ItemStackRenderer setPartialTickTime(float partialTickTime) {
        this.partialTickTime = partialTickTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackRenderer)) {
            return false;
        }
        ItemStackRenderer other = (ItemStackRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (Float.compare(this.getZLevel(), other.getZLevel()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleX(), other.getScaleX()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleY(), other.getScaleY()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleZ(), other.getScaleZ()) != 0) {
            return false;
        }
        if (this.isRenderEffects() != other.isRenderEffects()) {
            return false;
        }
        if (this.isIgnoreDepth() != other.isIgnoreDepth()) {
            return false;
        }
        if (this.isRenderInColor() != other.isRenderInColor()) {
            return false;
        }
        if (Float.compare(this.getPartialTickTime(), other.getPartialTickTime()) != 0) {
            return false;
        }
        RenderManager this$renderManager = this.getRenderManager();
        RenderManager other$renderManager = other.getRenderManager();
        if (this$renderManager == null ? other$renderManager != null : !this$renderManager.equals(other$renderManager)) {
            return false;
        }
        RenderBlocks this$renderBlocks = this.getRenderBlocks();
        RenderBlocks other$renderBlocks = other.getRenderBlocks();
        if (this$renderBlocks == null ? other$renderBlocks != null : !this$renderBlocks.equals(other$renderBlocks)) {
            return false;
        }
        RenderItem this$renderItem = this.getRenderItem();
        RenderItem other$renderItem = other.getRenderItem();
        if (this$renderItem == null ? other$renderItem != null : !this$renderItem.equals(other$renderItem)) {
            return false;
        }
        TextureManager this$texManager = this.getTexManager();
        TextureManager other$texManager = other.getTexManager();
        if (this$texManager == null ? other$texManager != null : !this$texManager.equals(other$texManager)) {
            return false;
        }
        FontRenderer this$fontRenderer = this.getFontRenderer();
        FontRenderer other$fontRenderer = other.getFontRenderer();
        if (this$fontRenderer == null ? other$fontRenderer != null : !this$fontRenderer.equals(other$fontRenderer)) {
            return false;
        }
        ItemStack this$itemstack = this.getItemstack();
        ItemStack other$itemstack = other.getItemstack();
        if (this$itemstack == null ? other$itemstack != null : !this$itemstack.equals(other$itemstack)) {
            return false;
        }
        DisplayAmount this$displayAmount = this.getDisplayAmount();
        DisplayAmount other$displayAmount = other.getDisplayAmount();
        if (this$displayAmount == null ? other$displayAmount != null : !((Object)((Object)this$displayAmount)).equals((Object)other$displayAmount)) {
            return false;
        }
        EntityItem this$entityitem = this.getEntityitem();
        EntityItem other$entityitem = other.getEntityitem();
        if (this$entityitem == null ? other$entityitem != null : !this$entityitem.equals(other$entityitem)) {
            return false;
        }
        World this$worldObj = this.getWorldObj();
        World other$worldObj = other.getWorldObj();
        return !(this$worldObj == null ? other$worldObj != null : !this$worldObj.equals(other$worldObj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStackRenderer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosX();
        result = result * 59 + this.getPosY();
        result = result * 59 + Float.floatToIntBits(this.getZLevel());
        result = result * 59 + Float.floatToIntBits(this.getScaleX());
        result = result * 59 + Float.floatToIntBits(this.getScaleY());
        result = result * 59 + Float.floatToIntBits(this.getScaleZ());
        result = result * 59 + (this.isRenderEffects() ? 79 : 97);
        result = result * 59 + (this.isIgnoreDepth() ? 79 : 97);
        result = result * 59 + (this.isRenderInColor() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getPartialTickTime());
        RenderManager $renderManager = this.getRenderManager();
        result = result * 59 + ($renderManager == null ? 43 : $renderManager.hashCode());
        RenderBlocks $renderBlocks = this.getRenderBlocks();
        result = result * 59 + ($renderBlocks == null ? 43 : $renderBlocks.hashCode());
        RenderItem $renderItem = this.getRenderItem();
        result = result * 59 + ($renderItem == null ? 43 : $renderItem.hashCode());
        TextureManager $texManager = this.getTexManager();
        result = result * 59 + ($texManager == null ? 43 : $texManager.hashCode());
        FontRenderer $fontRenderer = this.getFontRenderer();
        result = result * 59 + ($fontRenderer == null ? 43 : $fontRenderer.hashCode());
        ItemStack $itemstack = this.getItemstack();
        result = result * 59 + ($itemstack == null ? 43 : $itemstack.hashCode());
        DisplayAmount $displayAmount = this.getDisplayAmount();
        result = result * 59 + ($displayAmount == null ? 43 : ((Object)((Object)$displayAmount)).hashCode());
        EntityItem $entityitem = this.getEntityitem();
        result = result * 59 + ($entityitem == null ? 43 : $entityitem.hashCode());
        World $worldObj = this.getWorldObj();
        result = result * 59 + ($worldObj == null ? 43 : $worldObj.hashCode());
        return result;
    }

    public String toString() {
        return "ItemStackRenderer(renderManager=" + this.getRenderManager() + ", renderBlocks=" + this.getRenderBlocks() + ", renderItem=" + this.getRenderItem() + ", texManager=" + this.getTexManager() + ", fontRenderer=" + this.getFontRenderer() + ", itemstack=" + this.getItemstack() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", zLevel=" + this.getZLevel() + ", scaleX=" + this.getScaleX() + ", scaleY=" + this.getScaleY() + ", scaleZ=" + this.getScaleZ() + ", displayAmount=" + (Object)((Object)this.getDisplayAmount()) + ", renderEffects=" + this.isRenderEffects() + ", ignoreDepth=" + this.isIgnoreDepth() + ", renderInColor=" + this.isRenderInColor() + ", entityitem=" + this.getEntityitem() + ", worldObj=" + this.getWorldObj() + ", partialTickTime=" + this.getPartialTickTime() + ")";
    }

    public static enum DisplayAmount {
        HIDE_ONE,
        ALWAYS,
        NEVER;

    }
}

