/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Iterator;
import java.util.LinkedList;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.resources.DictResource;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrderLinkedList;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsItemOrderManager
extends LogisticsOrderManager<LogisticsItemOrder, DictResource.Identifier> {
    public LogisticsItemOrderManager(ILPPositionProvider pos) {
        super(new LogisticsOrderLinkedList<LogisticsItemOrder, DictResource.Identifier>(new IC()), pos);
    }

    public LogisticsItemOrderManager(IChangeListener listener, ILPPositionProvider pos) {
        super(listener, pos, new LogisticsOrderLinkedList<LogisticsItemOrder, DictResource.Identifier>(new IC()));
    }

    @Override
    public void sendFailed() {
        ((LogisticsItemOrder)this._orders.getFirst()).sendFailed();
        super.sendFailed();
    }

    public LogisticsItemOrder addOrder(ItemIdentifierStack stack, IRequestItems requester, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        LogisticsItemOrder order = new LogisticsItemOrder(new DictResource(stack, null), requester, type, info);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    public LogisticsItemOrder addOrder(DictResource stack, IRequestItems requester, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        LogisticsItemOrder order = new LogisticsItemOrder(stack, requester, type, info);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    public LogisticsItemOrderExtra addExtra(DictResource stack) {
        LogisticsItemOrderExtra order = new LogisticsItemOrderExtra(stack, null, IOrderInfoProvider.ResourceType.EXTRA, null);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    public void removeExtras(DictResource resource) {
        int itemsToRemove = resource.getRequestedAmount();
        DictResource.Identifier ident = resource.getIdentifier();
        Iterator iter = this._orders.iterator();
        LinkedList<LogisticsItemOrder> toRemove = new LinkedList<LogisticsItemOrder>();
        while (iter.hasNext()) {
            LogisticsItemOrder order = (LogisticsItemOrder)iter.next();
            if (order.getType() != IOrderInfoProvider.ResourceType.EXTRA || !order.getResource().getIdentifier().equals(ident)) continue;
            if (itemsToRemove >= order.getAmount()) {
                toRemove.add(order);
                if ((itemsToRemove -= order.getAmount()) != 0) continue;
                this._orders.removeAll(toRemove);
                return;
            }
            order.getResource().getItemStack().setStackSize(order.getAmount() - itemsToRemove);
            break;
        }
        this._orders.removeAll(toRemove);
    }

    public int totalItemsCountInOrders(ItemIdentifier item) {
        int itemCount = 0;
        for (LogisticsItemOrder request : this._orders) {
            if (!request.getResource().getItem().equals(item)) continue;
            itemCount += request.getResource().stack.getStackSize();
        }
        return itemCount;
    }

    private static class LogisticsItemOrderExtra
    extends LogisticsItemOrder {
        public LogisticsItemOrderExtra(DictResource item, IRequestItems destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
            super(item, destination, type, info);
        }
    }

    private static class IC
    implements LogisticsOrderLinkedList.IIdentityProvider<LogisticsItemOrder, DictResource.Identifier> {
        private IC() {
        }

        @Override
        public DictResource.Identifier getIdentity(LogisticsItemOrder o) {
            if (o == null || o.getResource() == null) {
                return null;
            }
            return o.getResource().getIdentifier();
        }

        @Override
        public boolean isExtra(LogisticsItemOrder o) {
            return o instanceof LogisticsItemOrderExtra;
        }
    }
}

