/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IInventoryCallback;
import openmods.block.OpenBlock;
import openmods.geometry.Orientation;
import openmods.inventory.GenericInventory;
import openmods.network.DimCoord;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.IRpcTargetProvider;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.TileEntityRpcTarget;
import openmods.network.senders.IPacketSender;
import openmods.reflection.TypeUtils;
import openmods.utils.Coord;

public abstract class OpenTileEntity
extends TileEntity
implements IRpcTargetProvider {
    private boolean isUsedForClientInventoryRendering = false;

    public void setup() {
    }

    public Coord getPosition() {
        return new Coord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public DimCoord getDimCoords() {
        return new DimCoord(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Orientation getOrientation() {
        Block block = this.func_145838_q();
        if (!(block instanceof OpenBlock)) {
            return Orientation.XP_YP;
        }
        OpenBlock openBlock = (OpenBlock)block;
        if (this.isUsedForClientInventoryRendering) {
            return openBlock.getInventoryRenderOrientation();
        }
        return openBlock.getOrientation(this.func_145832_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        if (this.field_145850_b != null) {
            System.out.println("SEVERE PROGRAMMER ERROR! Inventory Render on World TileEntity. Expect hell!");
        }
        this.isUsedForClientInventoryRendering = true;
        this.field_145854_h = block;
        this.field_145847_g = metadata;
    }

    public boolean isAddedToWorld() {
        return this.field_145850_b != null;
    }

    private TileEntity getTileEntity(int x, int y, int z) {
        return this.field_145850_b != null && this.field_145850_b.func_72899_e(x, y, z) ? this.field_145850_b.func_147438_o(x, y, z) : null;
    }

    public TileEntity getTileInDirection(ForgeDirection direction) {
        return this.getNeighbour(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public TileEntity getNeighbour(int dx, int dy, int dz) {
        return this.getTileEntity(this.field_145851_c + dx, this.field_145848_d + dy, this.field_145849_e + dz);
    }

    public String toString() {
        return String.format("%s,%s,%s", this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isAirBlock(ForgeDirection direction) {
        return this.field_145850_b != null && this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
    }

    public void sendBlockEvent(int event, int param) {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), event, param);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public void openGui(Object instance, EntityPlayer player) {
        player.openGui(instance, -1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AxisAlignedBB getBB() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean isRenderedInInventory() {
        return this.isUsedForClientInventoryRendering;
    }

    @Override
    public IRpcTarget createRpcTarget() {
        return new TileEntityRpcTarget(this);
    }

    public <T> T createProxy(IPacketSender sender, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        TypeUtils.isInstance(this, mainIntf, extraIntf);
        return RpcCallDispatcher.INSTANCE.createProxy(this.createRpcTarget(), sender, mainIntf, extraIntf);
    }

    public <T> T createClientRpcProxy(Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        IPacketSender sender = RpcCallDispatcher.INSTANCE.senders.client;
        return this.createProxy(sender, mainIntf, extraIntf);
    }

    public <T> T createServerRpcProxy(Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        IPacketSender sender = RpcCallDispatcher.INSTANCE.senders.block.bind(this.getDimCoords());
        return this.createProxy(sender, mainIntf, extraIntf);
    }

    public void markUpdated() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    protected IInventoryCallback createInventoryCallback() {
        return new IInventoryCallback(){

            @Override
            public void onInventoryChanged(IInventory inventory, int slotNumber) {
                OpenTileEntity.this.markUpdated();
            }
        };
    }

    protected GenericInventory registerInventoryCallback(GenericInventory inventory) {
        return inventory.addCallback(this.createInventoryCallback());
    }

    public boolean isValid(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

