/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Objects;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.api.IValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableUUID
extends SyncableObjectBase
implements IValueProvider<UUID> {
    private UUID uuid;

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        if (stream.readBoolean()) {
            long msb = stream.readLong();
            long lsb = stream.readLong();
            this.uuid = new UUID(msb, lsb);
        } else {
            this.uuid = null;
        }
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        if (this.uuid != null) {
            stream.writeBoolean(true);
            stream.writeLong(this.uuid.getMostSignificantBits());
            stream.writeLong(this.uuid.getLeastSignificantBits());
        } else {
            stream.writeBoolean(false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        if (this.uuid != null) {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74772_a("MSB", this.uuid.getMostSignificantBits());
            result.func_74772_a("LSB", this.uuid.getLeastSignificantBits());
            nbt.func_74782_a(name, (NBTBase)result);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound data = nbt.func_74775_l(name);
            long msb = data.func_74763_f("MSB");
            long lsb = data.func_74763_f("LSB");
            this.uuid = new UUID(msb, lsb);
        } else {
            this.uuid = null;
        }
    }

    public void setValue(UUID value) {
        if (!Objects.equal((Object)this.uuid, (Object)value)) {
            this.uuid = value;
            this.markDirty();
        }
    }

    public void clear() {
        this.setValue(null);
    }

    @Override
    public UUID getValue() {
        return this.uuid;
    }
}

