/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import openmods.datastore.IDataVisitor;
import openmods.network.rpc.IRpcTarget;

public class TargetWrapperRegistry
implements IDataVisitor<String, Integer> {
    private Map<String, Class<? extends IRpcTarget>> targets = ImmutableMap.of();
    private BiMap<Class<? extends IRpcTarget>, Integer> wrapperCls = HashBiMap.create();

    @Override
    public void begin(int size) {
        this.wrapperCls.clear();
    }

    @Override
    public void entry(String clsName, Integer clsId) {
        Class<? extends IRpcTarget> cls = this.targets.get(clsName);
        try {
            cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s has no parameterless constructor", clsName), e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.wrapperCls.put(cls, (Object)clsId);
    }

    @Override
    public void end() {
    }

    public int getWrapperId(Class<? extends IRpcTarget> cls) {
        Integer id = (Integer)this.wrapperCls.get(cls);
        Preconditions.checkNotNull((Object)id, (String)"Wrapper class %s is not registered", (Object[])new Object[]{cls});
        return id;
    }

    public IRpcTarget createWrapperFromId(int id) {
        Class cls = (Class)this.wrapperCls.inverse().get((Object)id);
        Preconditions.checkNotNull((Object)cls, (String)"Can't find class for id %s", (Object[])new Object[]{id});
        try {
            return (IRpcTarget)cls.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void addTargets(Map<String, Class<? extends IRpcTarget>> targets) {
        this.targets = ImmutableMap.copyOf(targets);
    }
}

