/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import openmods.calc.Environment;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.ICallable;
import openmods.calc.NullaryFunction;
import openmods.calc.UnaryFunction;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypeUserdata;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class OptionalType {
    private static final Optional<List<TypedValue>> ABSENT_MATCH = Optional.of(Collections.emptyList());

    private static TypedValue createPresentConstructor(final TypeDomain domain) {
        return domain.create(TypeUserdata.class, new TypeUserdata("optional.present", Value.class), MetaObject.builder().set(MetaObjectUtils.callableAdapter((ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return domain.create(Value.class, new Present(domain, value));
            }
        })).set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                Preconditions.checkArgument((variableCount == 1 ? 1 : 0) != 0, (String)"Invalid number of values to unpack, expected none got %s", (Object[])new Object[]{variableCount});
                if (input.is(Value.class)) {
                    Value optional = input.as(Value.class);
                    if (!optional.isPresent()) {
                        return Optional.absent();
                    }
                    ArrayList result = Lists.newArrayList((Object[])new TypedValue[]{optional.getValue()});
                    return Optional.of((Object)result);
                }
                return Optional.absent();
            }
        }).set(TypeUserdata.defaultStrSlot).set(TypeUserdata.defaultReprSlot).set(TypeUserdata.defaultAttrSlot(domain)).build());
    }

    private static TypedValue createAbsentConstructor(final TypeDomain domain) {
        return domain.create(TypeUserdata.class, new TypeUserdata("optional.absent", Value.class), MetaObject.builder().set(MetaObjectUtils.callableAdapter((ICallable<TypedValue>)new NullaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call() {
                return OptionalType.absent(domain);
            }
        })).set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                Preconditions.checkArgument((variableCount == 0 ? 1 : 0) != 0, (String)"Invalid number of values to unpack, expected none got %s", (Object[])new Object[]{variableCount});
                if (input.is(Value.class)) {
                    if (input.as(Value.class).isPresent()) {
                        return Optional.absent();
                    }
                    return ABSENT_MATCH;
                }
                return Optional.absent();
            }
        }).set(TypeUserdata.defaultStrSlot).set(TypeUserdata.defaultReprSlot).set(TypeUserdata.defaultAttrSlot(domain)).build());
    }

    private static TypedValue createOptionalType(final TypedValue nullValue, TypedValue presentTypeValue, TypedValue absentTypeValue) {
        final TypeDomain domain = nullValue.domain;
        ImmutableMap methods = ImmutableMap.builder().put((Object)"from", (Object)CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value == nullValue ? OptionalType.absent(domain) : OptionalType.present(domain, value);
            }
        })).put((Object)"present", (Object)presentTypeValue).put((Object)"absent", (Object)absentTypeValue).put((Object)"name", (Object)domain.create(String.class, "optional")).build();
        return domain.create(TypeUserdata.class, new TypeUserdata("optional", Value.class), MetaObject.builder().set(TypeUserdata.defaultStrSlot).set(TypeUserdata.defaultReprSlot).set(MetaObjectUtils.DECOMPOSE_ON_TYPE).set(MetaObjectUtils.attrFromMap((Map<String, TypedValue>)methods)).set(MetaObjectUtils.dirFromIterable(methods.keySet())).build());
    }

    public static void register(Environment<TypedValue> env, TypedValue nullValue) {
        TypeDomain domain = nullValue.domain;
        TypedValue presentConstructor = OptionalType.createPresentConstructor(domain);
        TypedValue absentConstructor = OptionalType.createAbsentConstructor(domain);
        final TypedValue typeValue = OptionalType.createOptionalType(nullValue, presentConstructor, absentConstructor);
        env.setGlobalSymbol("optional", typeValue);
        domain.registerType(Value.class, "optional", MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                return self.as(Value.class).attr(key);
            }
        }).set(new MetaObject.SlotDir(){

            @Override
            public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Value.class).dir();
            }
        }).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Value.class).str();
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Value.class).repr();
            }
        }).set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Value.class).isPresent();
            }
        }).set(new MetaObject.SlotType(){

            @Override
            public TypedValue type(TypedValue self, Frame<TypedValue> frame) {
                return typeValue;
            }
        }).build());
    }

    public static TypedValue absent(TypeDomain domain) {
        return domain.create(Value.class, new Absent(domain));
    }

    public static TypedValue present(TypeDomain domain, TypedValue value) {
        return domain.create(Value.class, new Present(domain, value));
    }

    public static TypedValue wrapNullable(TypeDomain domain, TypedValue result) {
        return result != null ? OptionalType.present(domain, result) : OptionalType.absent(domain);
    }

    public static TypedValue fromOptional(TypeDomain domain, Optional<TypedValue> value) {
        return value.isPresent() ? OptionalType.present(domain, (TypedValue)value.get()) : OptionalType.absent(domain);
    }

    private static class Absent
    extends Value {
        public Absent(TypeDomain domain) {
            super(domain);
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public TypedValue getValue() {
            throw new IllegalStateException("No value");
        }

        @Override
        public String str() {
            return "absent";
        }

        @Override
        public String repr() {
            return "optional.absent()";
        }

        @Override
        public TypedValue or(TypedValue value) {
            return value;
        }

        @Override
        public void orCall(Frame<TypedValue> frame, TypedValue arg) {
            MetaObjectUtils.call(frame, arg, OptionalInt.ZERO, OptionalInt.ONE);
        }

        @Override
        public TypedValue map(Frame<TypedValue> frame, TypedValue arg) {
            Preconditions.checkArgument((boolean)MetaObjectUtils.isCallable(arg), (String)"Value is not callable: %s", (Object[])new Object[]{arg});
            return this.domain.create(Value.class, this);
        }

        @Override
        public Optional<TypedValue> asOptional() {
            return Optional.absent();
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Absent;
        }
    }

    private static class Present
    extends Value {
        private final TypedValue value;

        public Present(TypeDomain domain, TypedValue value) {
            super(domain);
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public TypedValue getValue() {
            return this.value;
        }

        @Override
        public String str() {
            return "present: " + this.value;
        }

        @Override
        public String repr() {
            return "optional.present(" + this.value + ")";
        }

        @Override
        public TypedValue or(TypedValue value) {
            return this.value;
        }

        @Override
        public void orCall(Frame<TypedValue> frame, TypedValue arg) {
            Preconditions.checkArgument((boolean)MetaObjectUtils.isCallable(arg), (String)"Value is not callable: %s", (Object[])new Object[]{arg});
            frame.stack().push(this.value);
        }

        @Override
        public TypedValue map(Frame<TypedValue> frame, TypedValue arg) {
            Frame<TypedValue> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 0);
            Stack<TypedValue> stack = executionFrame.stack();
            stack.push(this.value);
            MetaObjectUtils.call(executionFrame, arg, OptionalInt.ONE, OptionalInt.ONE);
            TypedValue result = stack.popAndExpectEmptyStack();
            return OptionalType.present(this.domain, result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Present) {
                Present other = (Present)obj;
                return other.value.equals(this.value);
            }
            return false;
        }

        @Override
        public Optional<TypedValue> asOptional() {
            return Optional.of((Object)this.value);
        }
    }

    public static abstract class Value {
        private final Map<String, TypedValue> members;
        protected TypeDomain domain;

        public Value(TypeDomain domain) {
            this.domain = domain;
            ImmutableMap.Builder members = ImmutableMap.builder();
            members.put((Object)"get", (Object)CallableValue.wrap(domain, (ICallable<TypedValue>)new NullaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call() {
                    return this.getValue();
                }
            }));
            members.put((Object)"or", (Object)CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call(TypedValue value) {
                    return this.or(value);
                }
            }));
            members.put((Object)"orCall", (Object)CallableValue.wrap(domain, (ICallable<TypedValue>)new FixedCallable<TypedValue>(1, 1){

                @Override
                public void call(Frame<TypedValue> frame) {
                    TypedValue arg = frame.stack().pop();
                    this.orCall(frame, arg);
                }
            }));
            members.put((Object)"map", (Object)CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.WithFrame<TypedValue>(){

                @Override
                public TypedValue call(Frame<TypedValue> frame, TypedValue arg) {
                    return this.map(frame, arg);
                }
            }));
            members.put((Object)"isPresent", (Object)domain.create(Boolean.class, this.isPresent()));
            this.members = members.build();
        }

        public Optional<TypedValue> attr(String key) {
            return Optional.fromNullable((Object)this.members.get(key));
        }

        public Iterable<String> dir() {
            return this.members.keySet();
        }

        public abstract TypedValue or(TypedValue var1);

        public abstract void orCall(Frame<TypedValue> var1, TypedValue var2);

        public abstract TypedValue map(Frame<TypedValue> var1, TypedValue var2);

        public abstract boolean isPresent();

        public abstract TypedValue getValue();

        public abstract String str();

        public abstract String repr();

        public abstract Optional<TypedValue> asOptional();
    }
}

