/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import shukaro.warptheory.handlers.WarpEventRegistry;

public class ConfigHandler {
    public static Configuration config;
    public static boolean wussMode;
    public static boolean disableRebound;
    public static int permWarpMult;
    public static boolean allowPermWarpRemoval;
    public static boolean allowGlobalWarpEffects;
    public static boolean allowMultiWarpEffects;
    public static boolean allowWarpEffects;
    public static boolean allowServerKickWarpEffects;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            config.addCustomCategoryComment("general", "Change the inner workings of the mod requires restart");
            config.addCustomCategoryComment("warp_effects", "Toggle specific warp effect, If all disabled Pure Tear will not work");
            config.setCategoryRequiresMcRestart("general", true);
            ConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        wussMode = config.getBoolean("wussMode", "general", false, "enables less expensive recipes");
        disableRebound = config.getBoolean("disableRebound", "general", false, "disable warp events ignoring warpwarding which occur by Pure Tear");
        permWarpMult = config.getInt("permWarpMult", "general", 1, 0, Integer.MAX_VALUE, "how much more 'expensive' permanent warp is compared to normal warp");
        allowPermWarpRemoval = config.getBoolean("allowPermWarpRemoval", "general", true, "whether items can remove permanent warp or not");
        allowGlobalWarpEffects = config.getBoolean("allowGlobalWarpEffects", "general", true, "whether warp effects that involve the environment are triggered");
        allowMultiWarpEffects = config.getBoolean("allowMultiWarpEffects", "general", true, "whether multi-level warp effects are allowed. If false, only the first level will trigger");
        allowWarpEffects = config.getBoolean("addWarpEffects", "general", true, "whether to add general warp effects. If false extra effects will only be seen when using Pure Tear");
        allowServerKickWarpEffects = config.getBoolean("allowServerErrorWarpEffects", "general", false, "whether to allow warp effects known to cause errors on servers");
        Arrays.stream(WarpEventRegistry.values()).forEach(warpEvent -> warpEvent.loadConfig(config));
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("WarpTheory")) {
            ConfigHandler.loadConfiguration();
        }
    }

    static {
        wussMode = false;
        disableRebound = false;
        permWarpMult = 4;
        allowPermWarpRemoval = true;
        allowGlobalWarpEffects = false;
        allowMultiWarpEffects = false;
        allowWarpEffects = false;
        allowServerKickWarpEffects = false;
    }
}

