/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat.baubles;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import magicbees.bees.BeeManager;
import magicbees.main.utils.compat.baubles.InventoryBeeRing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class RingHousing
implements IBeeHousing {
    private final EntityPlayer player;
    private final BiomeGenBase biome;
    private final IBeeHousingInventory inventory;
    private final IBeekeepingLogic beekeepingLogic;
    private static final IErrorLogic errorLogic = new RingErrorLogic();
    private static final Iterable<IBeeListener> beeListeners = ImmutableSet.of((Object)new DefaultBeeListener());
    private static final Iterable<IBeeModifier> beeModifiers = ImmutableSet.of((Object)new RingHousingModifier());

    public RingHousing(EntityPlayer player, InventoryBeeRing inventoryBeeRing) {
        this.player = player;
        this.biome = player.func_130014_f_().func_72807_a((int)player.field_70165_t, (int)player.field_70163_u);
        this.inventory = new RingBeeHousingInventory(inventoryBeeRing);
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return beeModifiers;
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return beeListeners;
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    public int getBlockLightValue() {
        return this.player.func_130014_f_().func_72957_l((int)this.player.field_70165_t, (int)this.player.field_70163_u + 1, (int)this.player.field_70161_v);
    }

    public boolean canBlockSeeTheSky() {
        return this.player.func_130014_f_().func_72937_j((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
    }

    public World getWorld() {
        return this.player.func_130014_f_();
    }

    public GameProfile getOwner() {
        return this.player.func_146103_bH();
    }

    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)this.player.field_70165_t, (double)(this.player.field_70163_u + 0.5), (double)this.player.field_70161_v);
    }

    public BiomeGenBase getBiome() {
        return this.biome;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome((BiomeGenBase)this.biome, (int)((int)this.player.field_70165_t), (int)((int)this.player.field_70163_u), (int)((int)this.player.field_70161_v));
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.biome.field_76751_G);
    }

    public IErrorLogic getErrorLogic() {
        return errorLogic;
    }

    public ChunkCoordinates getCoordinates() {
        return this.player.func_82114_b();
    }

    private static class RingHousingModifier
    implements IBeeModifier {
        private RingHousingModifier() {
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 0.9f;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public boolean isSealed() {
            return true;
        }

        public boolean isSelfLighted() {
            return true;
        }

        public boolean isSunlightSimulated() {
            return true;
        }

        public boolean isHellish() {
            return false;
        }
    }

    private static class RingErrorLogic
    implements IErrorLogic {
        private RingErrorLogic() {
        }

        public boolean setCondition(boolean condition, IErrorState errorState) {
            return condition;
        }

        public boolean contains(IErrorState state) {
            return false;
        }

        public boolean hasErrors() {
            return false;
        }

        public void clearErrors() {
        }

        public void writeData(DataOutputStream data) throws IOException {
        }

        public void readData(DataInputStream data) throws IOException {
        }

        public ImmutableSet<IErrorState> getErrorStates() {
            return ImmutableSet.of();
        }
    }

    private static class RingBeeHousingInventory
    implements IBeeHousingInventory {
        private final InventoryBeeRing inventoryBeeRing;

        public RingBeeHousingInventory(InventoryBeeRing IBR) {
            this.inventoryBeeRing = IBR;
        }

        public ItemStack getQueen() {
            return this.inventoryBeeRing.getQueen();
        }

        public ItemStack getDrone() {
            return null;
        }

        public void setQueen(ItemStack itemStack) {
            this.inventoryBeeRing.setQueen(itemStack);
        }

        public void setDrone(ItemStack itemstack) {
        }

        public boolean addProduct(ItemStack product, boolean all) {
            return false;
        }
    }
}

