/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ParticleGenPacket
implements IMessage {
    byte id = 0;
    short value = 0;
    int tileX = 0;
    int tileY = 0;
    int tileZ = 0;

    public ParticleGenPacket() {
    }

    public ParticleGenPacket(byte id, short value, int x, int y, int z) {
        this.id = id;
        this.value = value;
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.id);
        bytes.writeShort((int)this.value);
        bytes.writeInt(this.tileX);
        bytes.writeInt(this.tileY);
        bytes.writeInt(this.tileZ);
    }

    public void fromBytes(ByteBuf bytes) {
        this.id = bytes.readByte();
        this.value = bytes.readShort();
        this.tileX = bytes.readInt();
        this.tileY = bytes.readInt();
        this.tileZ = bytes.readInt();
    }

    public static class Handler
    implements IMessageHandler<ParticleGenPacket, IMessage> {
        public IMessage onMessage(ParticleGenPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.tileX, message.tileY, message.tileZ);
            if (!(tile instanceof TileParticleGenerator)) {
                return null;
            }
            TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
            switch (message.id) {
                case 0: {
                    particleGenerator.red = message.value;
                    break;
                }
                case 1: {
                    particleGenerator.green = message.value;
                    break;
                }
                case 2: {
                    particleGenerator.blue = message.value;
                    break;
                }
                case 3: {
                    particleGenerator.motionX = (float)message.value / 1000.0f;
                    break;
                }
                case 4: {
                    particleGenerator.motionY = (float)message.value / 1000.0f;
                    break;
                }
                case 5: {
                    particleGenerator.motionZ = (float)message.value / 1000.0f;
                    break;
                }
                case 6: {
                    particleGenerator.scale = (float)message.value / 100.0f;
                    break;
                }
                case 7: {
                    particleGenerator.life = message.value;
                    break;
                }
                case 10: {
                    particleGenerator.randomRed = message.value;
                    break;
                }
                case 11: {
                    particleGenerator.randomGreen = message.value;
                    break;
                }
                case 12: {
                    particleGenerator.randomBlue = message.value;
                    break;
                }
                case 13: {
                    particleGenerator.randomMotionX = (float)message.value / 1000.0f;
                    break;
                }
                case 14: {
                    particleGenerator.randomMotionY = (float)message.value / 1000.0f;
                    break;
                }
                case 15: {
                    particleGenerator.randomMotionZ = (float)message.value / 1000.0f;
                    break;
                }
                case 16: {
                    particleGenerator.randomScale = (float)message.value / 100.0f;
                    break;
                }
                case 17: {
                    particleGenerator.randomLife = message.value;
                    break;
                }
                case 20: {
                    particleGenerator.spawnX = (float)message.value / 10.0f;
                    break;
                }
                case 21: {
                    particleGenerator.spawnY = (float)message.value / 10.0f;
                    break;
                }
                case 22: {
                    particleGenerator.spawnZ = (float)message.value / 10.0f;
                    break;
                }
                case 23: {
                    particleGenerator.spawnRate = message.value;
                    break;
                }
                case 24: {
                    particleGenerator.fade = message.value;
                    break;
                }
                case 25: {
                    particleGenerator.gravity = (float)message.value / 1000.0f;
                    break;
                }
                case 30: {
                    particleGenerator.randomSpawnX = (float)message.value / 10.0f;
                    break;
                }
                case 31: {
                    particleGenerator.randomSpawnY = (float)message.value / 10.0f;
                    break;
                }
                case 32: {
                    particleGenerator.randomSpawnZ = (float)message.value / 10.0f;
                    break;
                }
                case 40: {
                    particleGenerator.beamRed = message.value;
                    break;
                }
                case 41: {
                    particleGenerator.beamGreen = message.value;
                    break;
                }
                case 42: {
                    particleGenerator.beamBlue = message.value;
                    break;
                }
                case 43: {
                    particleGenerator.beamPitch = (float)message.value / 10.0f;
                    break;
                }
                case 44: {
                    particleGenerator.beamYaw = (float)message.value / 10.0f;
                    break;
                }
                case 45: {
                    particleGenerator.beamRotation = (float)message.value / 100.0f;
                    break;
                }
                case 46: {
                    particleGenerator.beamScale = (float)message.value / 100.0f;
                    break;
                }
                case 47: {
                    particleGenerator.beamLength = (float)message.value / 100.0f;
                    break;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    particleGenerator.page = message.value;
                    break;
                }
                case 110: {
                    particleGenerator.canParticleCollide = message.value == 1;
                    break;
                }
                case 111: {
                    particleGenerator.selectedParticle = message.value;
                    break;
                }
                case 112: {
                    particleGenerator.isParticlesEnabled = message.value == 1;
                    break;
                }
                case 120: {
                    particleGenerator.isBeamEnabled = message.value == 1;
                    break;
                }
                case 121: {
                    particleGenerator.shouldRenderCore = message.value == 1;
                }
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.id == 127) {
                if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151121_aF)) {
                    this.giveNote(message, player);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("You need paper in your inventory to do that"));
                }
            }
            player.field_70170_p.func_147471_g(message.tileX, message.tileY, message.tileZ);
            return null;
        }

        private void giveNote(ParticleGenPacket message, EntityPlayerMP player) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_146026_a(Items.field_151121_aF);
            }
            ItemStack stack = new ItemStack(Items.field_151121_aF);
            stack.func_77982_d(new NBTTagCompound());
            TileEntity tile = player.field_70170_p.func_147438_o(message.tileX, message.tileY, message.tileZ);
            if (tile instanceof TileParticleGenerator) {
                TileParticleGenerator particleGenerator = (TileParticleGenerator)tile;
                particleGenerator.getBlockNBT(stack.func_77978_p());
                stack.func_151001_c("Saved Particle Gen Settings");
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
            }
        }
    }
}

