/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.crafting.CraftingLink;
import appeng.helpers.NonNullArrayIterator;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.AeStackInventory;
import com.glodblock.github.inventory.AeStackInventoryImpl;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.concurrent.Future;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileLevelMaintainer
extends AENetworkTile
implements IAEAppEngInventory,
IGridTickable,
ICraftingRequester,
IPowerChannelState {
    public static final int REQ_COUNT = 5;
    public final InventoryRequest requests = new InventoryRequest(this);
    private final BaseActionSource source;
    private final IInventory inv = new AeItemStackHandler(this.requests.getRequestStacks());
    private boolean isPowered = false;

    public TileLevelMaintainer() {
        this.getProxy().setIdlePowerUsage(1.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
    }

    public AeStackInventory<IAEItemStack> getRequestSlots() {
        return this.requests.getRequestStacks();
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.copyOf((Iterator)new NonNullArrayIterator((Object[])this.requests.getLinks()));
    }

    private IAEItemStack setState(ICraftingLink link, IAEItemStack items) {
        if (items != null) {
            this.requests.setState(link, State.Exporting);
        } else {
            this.requests.setState(link, State.Crafting);
        }
        return items;
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        try {
            double power;
            IEnergyGrid energy;
            if (this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = Math.ceil(ItemFluidDrop.isFluidStack(items) ? (double)items.getStackSize() / 1000.0 : (double)items.getStackSize()), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (ItemFluidDrop.isFluidStack(items)) {
                    IAEFluidStack notInserted = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().injectItems((IAEStack)ItemFluidDrop.getAeFluidStack(items), mode, this.source);
                    if (notInserted != null) {
                        items.setStackSize(notInserted.getStackSize());
                        return this.setState(link, items);
                    }
                    return null;
                }
                return this.setState(link, (IAEItemStack)this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)items, mode, this.source));
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return this.setState(link, items);
    }

    public void jobStateChange(ICraftingLink link) {
        if (this.requests.getLinks() != null) {
            for (int x = 0; x < this.requests.getLinks().length; ++x) {
                if (this.requests.getLinks()[x] != link) continue;
                this.requests.getLinks()[x] = link;
                return;
            }
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(5, 120, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.canDoBusWork() ? this.doWork() : TickRateModulation.IDLE;
    }

    private TickRateModulation doWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        boolean didSomething = false;
        try {
            ICraftingGrid cg = this.getProxy().getCrafting();
            IGrid grid = this.getProxy().getGrid();
            IItemList inv = this.getProxy().getStorage().getItemInventory().getStorageList();
            for (int i = 0; i < 5; ++i) {
                IAEItemStack is = this.requests.getRequestQtyStack(i);
                if (is == null || this.requests.getBatchSize(i) <= 0L) continue;
                IAEItemStack craftItem = this.requests.getCraftItem(i);
                if (this.requests.isDone(i)) {
                    this.requests.setState(i, State.Idling);
                }
                if (cg.canEmitFor(craftItem) || cg.isRequesting(craftItem) || inv.findPrecise((IAEStack)is) == null || !((IAEItemStack)inv.findPrecise((IAEStack)is)).isCraftable() || ((IAEItemStack)inv.findPrecise((IAEStack)is)).getStackSize() >= is.getStackSize() || !this.requests.isDone(i)) continue;
                Future<ICraftingJob> jobTask = this.requests.getJobs()[i];
                if (jobTask == null) {
                    this.requests.getJobs()[i] = cg.beginCraftingJob(this.func_145831_w(), grid, this.source, craftItem, null);
                    continue;
                }
                if (!jobTask.isDone()) continue;
                this.requests.setState(i, State.Idling);
                try {
                    ICraftingJob job = jobTask.get();
                    if (job == null) continue;
                    ICraftingLink link = cg.submitJob(job, (ICraftingRequester)this, null, false, this.source);
                    ((InventoryRequest)this.requests).jobs[i] = null;
                    if (link == null) continue;
                    didSomething = true;
                    this.requests.setState(i, State.Crafting);
                    this.requests.getLinks()[i] = link;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    public void saveChanges() {
        super.saveChanges();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    public void gridChanged() {
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public InventoryRequest getRequestInventory() {
        return this.requests;
    }

    public IInventory getInventory() {
        return this.inv;
    }

    public void updateQuantity(int idx, long size) {
        this.requests.updateQuantity(idx, size);
    }

    public void updateBatchSize(int idx, long size) {
        this.requests.updateBatchSize(idx, size);
    }

    public void setRequestStatus(int idx, boolean enable) {
        this.requests.setEnable(idx, enable);
    }

    private void readLinkFromNBT(NBTTagCompound data) {
        try {
            for (int i = 0; i < this.requests.getLinks().length; ++i) {
                NBTTagCompound link = data.func_74775_l("links-" + i);
                if (link != null && link.func_82582_d()) {
                    this.requests.getLinks()[i] = null;
                    continue;
                }
                this.requests.getLinks()[i] = AEApi.instance().storage().loadCraftingLink(link, (ICraftingRequester)this);
                if (this.requests.isDone(i)) continue;
                this.requests.setState(i, State.Crafting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NBTTagCompound writeLinkToNBT(NBTTagCompound data) {
        for (int i = 0; i < this.requests.getLinks().length; ++i) {
            if (this.requests.getLinks()[i] == null) continue;
            CraftingLink link = (CraftingLink)this.requests.getLinks()[i];
            NBTTagCompound linkData = new NBTTagCompound();
            link.writeToNBT(linkData);
            data.func_74782_a("links-" + i, (NBTBase)linkData);
        }
        return data;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.requests.requestStacks.writeToNbt(data, "Inventory");
        this.requests.requestBatches.writeToNbt(data, "Batch");
        this.requests.requestQtys.writeToNbt(data, "Count");
        return this.writeLinkToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.requests.requestStacks.readFromNbt(data, "Inventory");
        this.requests.requestBatches.readFromNbt(data, "Batch");
        this.requests.requestQtys.readFromNbt(data, "Count");
        this.readLinkFromNBT(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    public static class InventoryRequest {
        private final AeStackInventoryImpl<IAEItemStack> requestStacks;
        private final AeStackInventoryImpl<IAEItemStack> requestBatches;
        private final AeStackInventoryImpl<IAEItemStack> requestQtys;
        private final Future<ICraftingJob>[] jobs;
        private final ICraftingLink[] links;
        private final State[] state = new State[5];

        public InventoryRequest(TileLevelMaintainer tile) {
            this.requestStacks = new AeStackInventoryImpl(StorageChannel.ITEMS, 5, tile);
            this.requestBatches = new AeStackInventoryImpl(StorageChannel.ITEMS, 5, tile);
            this.requestQtys = new AeStackInventoryImpl(StorageChannel.ITEMS, 5, tile);
            this.jobs = new Future[5];
            this.links = new ICraftingLink[5];
        }

        public void setEnable(int idx, boolean enable) {
            IAEItemStack ias = this.getRequestStacks().getStack(idx);
            IAEItemStack ias1 = this.getRequestBatches().getStack(idx);
            if (ias != null && ias1 != null) {
                ItemStack is = ias1.getItemStack();
                NBTTagCompound data = new NBTTagCompound();
                data.func_74757_a("Enable", enable);
                is.func_77982_d(data);
                AEItemStack i = AEItemStack.create((ItemStack)is);
                i.setStackSize(ias1.getStackSize());
                this.getRequestBatches().setStack(idx, (IAEItemStack)i);
            }
        }

        public State getState(int idx) {
            IAEItemStack ias = this.getRequestStacks().getStack(idx);
            if (ias == null) {
                return State.Nothing;
            }
            return this.state[idx] == null ? State.Idling : this.state[idx];
        }

        public void setState(ICraftingLink link, State state) {
            int i = 0;
            for (ICraftingLink link1 : this.getLinks()) {
                if (link == link1) {
                    this.setState(i, state);
                    break;
                }
                ++i;
            }
        }

        public void setState(int idx, State state) {
            this.state[idx] = state;
        }

        public boolean isEnable(int idx) {
            IAEItemStack ias = this.getRequestBatches().getStack(idx);
            if (ias != null) {
                ItemStack is = ias.getItemStack();
                try {
                    return is.func_77978_p().func_74767_n("Enable");
                }
                catch (NullPointerException e) {
                    return true;
                }
            }
            return true;
        }

        public boolean isDone(int index) {
            if (this.getLinks()[index] != null) {
                return this.getLinks()[index].isDone() || this.getLinks()[index].isCanceled();
            }
            return true;
        }

        public Future<ICraftingJob>[] getJobs() {
            return this.jobs;
        }

        public ICraftingLink[] getLinks() {
            return this.links;
        }

        public AeStackInventory<IAEItemStack> getRequestQtys() {
            return this.requestQtys;
        }

        public AeStackInventory<IAEItemStack> getRequestBatches() {
            return this.requestBatches;
        }

        public AeStackInventory<IAEItemStack> getRequestStacks() {
            return this.requestStacks;
        }

        public void updateQuantity(int idx, long size) {
            IAEItemStack is = this.getRequestStacks().getStack(idx);
            if (is != null) {
                IAEItemStack i = is.copy();
                i.setStackSize(size);
                this.getRequestQtys().setStack(idx, i);
            }
        }

        public void updateBatchSize(int idx, long size) {
            IAEItemStack ias = this.getRequestStacks().getStack(idx);
            if (ias != null) {
                ItemStack is = ias.copy().getItemStack();
                NBTTagCompound data = new NBTTagCompound();
                data.func_74757_a("Enable", true);
                is.func_77982_d(data);
                AEItemStack i = AEItemStack.create((ItemStack)is);
                i.setStackSize(size);
                this.getRequestBatches().setStack(idx, (IAEItemStack)i);
            }
        }

        public IAEItemStack getRequestQtyStack(int idx) {
            IAEItemStack is = this.getRequestStacks().getStack(idx);
            if (is == null) {
                return null;
            }
            IAEItemStack qis = this.getRequestQtys().getStack(idx);
            if (qis == null || !is.isSameType(qis)) {
                return null;
            }
            return this.getRequestQtys().getStack(idx);
        }

        public long getQuantity(int idx) {
            IAEItemStack ias = this.getRequestQtyStack(idx);
            if (ias == null) {
                return 0L;
            }
            return ias.getStackSize();
        }

        public long getBatchSize(int idx) {
            if (!this.isEnable(idx)) {
                return 0L;
            }
            IAEItemStack is = this.getRequestStacks().getStack(idx);
            IAEItemStack is1 = this.getRequestBatches().getStack(idx);
            if (is != null && is1 != null) {
                return is1.getStackSize();
            }
            return 0L;
        }

        public IAEItemStack getCraftItem(int idx) {
            IAEItemStack is = this.getRequestQtyStack(idx);
            if (is != null) {
                IAEItemStack ias = is.copy();
                ias.setStackSize(this.getBatchSize(idx));
                return ias;
            }
            return null;
        }
    }

    public static enum State {
        Nothing,
        Idling,
        Crafting,
        Exporting;

    }
}

