/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.Log;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.teleport.ItemTeleportStaff;
import crazypants.enderio.teleport.TravelController;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraftforge.common.MinecraftForge;

public class PacketLongDistanceTravelEvent
implements IMessage,
IMessageHandler<PacketLongDistanceTravelEvent, IMessage> {
    boolean conserveMotion;
    int entityId;
    int source;

    public PacketLongDistanceTravelEvent() {
    }

    public PacketLongDistanceTravelEvent(Entity entity, boolean conserveMotion, TravelSource source) {
        this.conserveMotion = conserveMotion;
        this.entityId = entity instanceof EntityPlayer ? -1 : entity.func_145782_y();
        this.source = source.ordinal();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.entityId);
        buf.writeInt(this.source);
    }

    public void fromBytes(ByteBuf buf) {
        this.conserveMotion = buf.readBoolean();
        this.entityId = buf.readInt();
        this.source = buf.readInt();
    }

    public IMessage onMessage(PacketLongDistanceTravelEvent message, MessageContext ctx) {
        if (message.entityId != -1) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to illegally tp other entity {}.", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH(), message.entityId});
            return null;
        }
        EntityPlayerMP toTp = ctx.getServerHandler().field_147369_b;
        TravelSource source = TravelSource.values()[message.source];
        if (!PacketLongDistanceTravelEvent.validate(toTp, source)) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to tp without valid prereq.", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH()});
            return null;
        }
        PacketLongDistanceTravelEvent.doServerTeleport((Entity)toTp, message.conserveMotion, source);
        return null;
    }

    private static boolean validate(EntityPlayerMP toTp, TravelSource source) {
        ItemStack equippedItem = toTp.func_71045_bC();
        switch (source) {
            case STAFF: {
                return equippedItem != null && equippedItem.func_77973_b() instanceof IItemOfTravel && ((IItemOfTravel)equippedItem.func_77973_b()).isActive((EntityPlayer)toTp, equippedItem);
            }
            case TELEPORT_STAFF: {
                return equippedItem != null && equippedItem.func_77973_b() instanceof ItemTeleportStaff;
            }
        }
        return false;
    }

    public static boolean doServerTeleport(Entity toTp, boolean conserveMotion, TravelSource source) {
        int used;
        EntityPlayer player = toTp instanceof EntityPlayer ? (EntityPlayer)toTp : null;
        Optional<BlockCoord> travelDestination = TravelController.instance.findTravelDestination(player, source);
        if (!travelDestination.isPresent()) {
            return false;
        }
        BlockCoord destination = travelDestination.get();
        int x = destination.x;
        int y = destination.y;
        int z = destination.z;
        int powerUse = TravelController.instance.getRequiredPower(player, source, destination);
        if (powerUse < 0) {
            return false;
        }
        if (player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemOfTravel && (used = ((IItemOfTravel)player.func_71045_bC().func_77973_b()).canExtractInternal(player.func_71045_bC(), powerUse)) != -1 && used != powerUse) {
            return false;
        }
        TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        x = evt.targetX;
        y = evt.targetY;
        z = evt.targetZ;
        toTp.field_70170_p.func_72908_a(toTp.field_70165_t, toTp.field_70163_u, toTp.field_70161_v, source.sound, 1.0f, 1.0f);
        toTp.func_85030_a(source.sound, 1.0f, 1.0f);
        if (player != null) {
            player.func_70634_a((double)x + 0.5, (double)y + 1.1, (double)z + 0.5);
        } else {
            toTp.func_70107_b((double)x, (double)y, (double)z);
        }
        toTp.field_70170_p.func_72908_a((double)x, (double)y, (double)z, source.sound, 1.0f, 1.0f);
        toTp.field_70143_R = 0.0f;
        if (player != null) {
            if (conserveMotion) {
                Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
                S12PacketEntityVelocity p = new S12PacketEntityVelocity(toTp.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
            }
            if (powerUse > 0 && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemOfTravel) {
                ItemStack item = player.func_71045_bC().func_77946_l();
                ((IItemOfTravel)item.func_77973_b()).extractInternal(item, powerUse);
                toTp.func_70062_b(0, item);
            }
        }
        return true;
    }
}

