/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.LiquidOutput;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.RedstoneControlMode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class AdvancedLiquidConduit
extends AbstractTankConduit {
    public static final int CONDUIT_VOLUME = 1000;
    public static final String ICON_KEY = "enderio:liquidConduitAdvanced";
    public static final String ICON_KEY_LOCKED = "enderio:liquidConduitAdvancedLocked";
    public static final String ICON_CORE_KEY = "enderio:liquidConduitCoreAdvanced";
    public static final String ICON_EXTRACT_KEY = "enderio:liquidConduitAdvancedInput";
    public static final String ICON_INSERT_KEY = "enderio:liquidConduitAdvancedOutput";
    public static final String ICON_EMPTY_EDGE = "enderio:liquidConduitAdvancedEdge";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private AdvancedLiquidConduitNetwork network;
    private long ticksSinceFailedExtract = 0L;
    public static final int MAX_EXTRACT_PER_TICK = Config.advancedFluidConduitExtractRate;
    public static final int MAX_IO_PER_TICK = Config.advancedFluidConduitMaxIoRate;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put(AdvancedLiquidConduit.ICON_KEY, register.func_94245_a(AdvancedLiquidConduit.ICON_KEY));
                ICONS.put(AdvancedLiquidConduit.ICON_CORE_KEY, register.func_94245_a(AdvancedLiquidConduit.ICON_CORE_KEY));
                ICONS.put(AdvancedLiquidConduit.ICON_EXTRACT_KEY, register.func_94245_a(AdvancedLiquidConduit.ICON_EXTRACT_KEY));
                ICONS.put(AdvancedLiquidConduit.ICON_INSERT_KEY, register.func_94245_a(AdvancedLiquidConduit.ICON_INSERT_KEY));
                ICONS.put(AdvancedLiquidConduit.ICON_EMPTY_EDGE, register.func_94245_a(AdvancedLiquidConduit.ICON_EMPTY_EDGE));
                ICONS.put(AdvancedLiquidConduit.ICON_KEY_LOCKED, register.func_94245_a(AdvancedLiquidConduit.ICON_KEY_LOCKED));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public AdvancedLiquidConduit() {
        this.updateTank();
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
        }
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        Fluid f = this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid();
        for (ForgeDirection dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir, MAX_EXTRACT_PER_TICK)) continue;
            this.ticksSinceFailedExtract = 0L;
        }
    }

    @Override
    protected void updateTank() {
        this.tank.setCapacity(1000);
        if (this.network != null) {
            this.network.updateConduitVolumes();
        }
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemLiquidConduit, 1, 1);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof AdvancedLiquidConduitNetwork)) {
            return false;
        }
        AdvancedLiquidConduitNetwork n = (AdvancedLiquidConduitNetwork)network;
        if (this.tank.getFluid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getFluid());
        } else if (!this.tank.getFluid().isFluidEqual(n.getFluidType())) {
            return false;
        }
        this.network = n;
        return true;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof AdvancedLiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((AdvancedLiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((AdvancedLiquidConduit)con).getFluidType());
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshInputs(dir);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshInputs(dir);
    }

    private void refreshInputs(ForgeDirection dir) {
        if (this.network == null) {
            return;
        }
        LiquidOutput lo = new LiquidOutput(this.getLocation().getLocation(dir), dir.getOpposite());
        this.network.removeInput(lo);
        if (this.canInputToDir(dir) && this.containsExternalConnection(dir)) {
            this.network.addInput(lo);
        }
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return this.fluidTypeLocked ? ICONS.get(ICON_KEY_LOCKED) : ICONS.get(ICON_KEY);
    }

    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_EXTRACT_KEY);
    }

    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_INSERT_KEY);
    }

    public IIcon getNotSetEdgeTexture() {
        return ICONS.get(ICON_EMPTY_EDGE);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidLiquid()) {
            return this.tank.getFluid().getFluid().getStillIcon();
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        if (this.filledFromThisTick.contains(this.getLocation().getLocation(from))) {
            return 0;
        }
        if (doFill) {
            this.filledFromThisTick.add(this.getLocation().getLocation(from));
        }
        return this.network.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.network == null || !this.getConnectionMode(from).acceptsOutput()) {
            return null;
        }
        return this.network.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.network == null || !this.getConnectionMode(from).acceptsOutput()) {
            return null;
        }
        return this.network.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.canExtractFromDir(from) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), new FluidStack(fluid, 0));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.canInputToDir(from) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), new FluidStack(fluid, 0));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.network == null) {
            return null;
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @Override
    protected boolean canJoinNeighbour(ILiquidConduit n) {
        return n instanceof AdvancedLiquidConduit;
    }

    @Override
    public AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork() {
        return this.network;
    }
}

