/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.screen;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.DraggableWindowWrapper;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IDraggable;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Cursor {
    private final ModularUIContext uiContext;
    @Nullable
    private IDraggable cursorDraggable;
    @Nullable
    private Widget hovered;
    @Nullable
    private Widget focused;
    private final List<Object> hoveredWidgets = new ArrayList<Object>();
    private int lastButton = -1;
    private long lastClickTime = 0L;
    private int timeHovered;

    protected Cursor(ModularUIContext context) {
        this.uiContext = context;
    }

    public Pos2d getPos() {
        return this.uiContext.getScreen().getMousePos();
    }

    public int getX() {
        return this.getPos().x;
    }

    public int getY() {
        return this.getPos().y;
    }

    public boolean isAbove(Widget widget) {
        return widget.isUnderMouse(this.getPos());
    }

    public boolean isAbove(IWidgetParent widget) {
        return this.getPos().isInside(widget.getAbsolutePos(), widget.getSize());
    }

    public boolean isHovering(Widget widget) {
        return this.hovered == widget;
    }

    @Nullable
    public Widget getHovered() {
        return this.hovered;
    }

    public boolean isFocused(Widget widget) {
        return this.focused == widget;
    }

    public void removeFocus(Widget widget) {
        if (this.focused != null && this.isFocused(widget)) {
            this.focused.onRemoveFocus();
            this.focused = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public void updateFocused(Widget widget) {
        if (widget != null) {
            if (this.focused == null || this.focused != widget) {
                if (this.focused != null) {
                    this.focused.onRemoveFocus();
                }
                this.focused = widget.shouldGetFocus() ? widget : null;
            }
        } else if (this.focused != null) {
            this.focused.onRemoveFocus();
            this.focused = null;
        }
    }

    @Nullable
    public Widget getFocused() {
        return this.focused;
    }

    public boolean isRightBelow(Widget widget) {
        return !this.hoveredWidgets.isEmpty() && this.hoveredWidgets.get(0) == widget;
    }

    public List<Object> getAllHovered() {
        return this.hoveredWidgets;
    }

    @ApiStatus.Internal
    public void updateHovered() {
        Widget w = this.findHoveredWidgets();
        if (w != this.hovered) {
            this.hovered = w;
            this.timeHovered = 0;
        }
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.uiContext.getPlayer().field_71071_by.func_70445_o();
    }

    public void setItemStack(ItemStack stack, boolean sync) {
        if (stack != null) {
            this.uiContext.getPlayer().field_71071_by.func_70437_b(stack);
            if (sync && !this.uiContext.isClient()) {
                this.uiContext.sendServerPacket(1, null, this.uiContext.getMainWindow(), buffer -> {
                    try {
                        buffer.func_150788_a(stack);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    public boolean hasDraggable() {
        return this.cursorDraggable != null;
    }

    public boolean isHoldingSomething() {
        return this.hasDraggable() || this.getItemStack() != null;
    }

    @Nullable
    public IDraggable getDraggable() {
        return this.cursorDraggable;
    }

    @Nullable
    public Rectangle getDraggableArea() {
        return this.cursorDraggable == null ? null : this.cursorDraggable.getArea();
    }

    public int getTimeHovered() {
        return this.timeHovered;
    }

    @ApiStatus.Internal
    public void draw(float partialTicks) {
        if (this.cursorDraggable != null) {
            this.cursorDraggable.renderMovingState(partialTicks);
        }
    }

    @ApiStatus.Internal
    public void onScreenUpdate() {
        if (this.hovered != null) {
            ++this.timeHovered;
        }
        if (this.cursorDraggable != null && this.getItemStack() != null) {
            this.cursorDraggable.onDragEnd(false);
            this.cursorDraggable.setMoving(false);
            this.cursorDraggable = null;
        }
        if (this.cursorDraggable != null) {
            this.cursorDraggable.onDrag(this.lastButton, Minecraft.func_71386_F() - this.lastClickTime);
        }
    }

    @ApiStatus.Internal
    public boolean onMouseClick(int button) {
        if ((button == 0 || button == 1) && this.getItemStack() == null && this.cursorDraggable != null) {
            ModularWindow window = this.findHoveredWindow();
            this.cursorDraggable.onDragEnd(this.cursorDraggable.canDropHere(this.hovered, window != null));
            this.cursorDraggable.setMoving(false);
            this.cursorDraggable = null;
            this.lastButton = -1;
            this.lastClickTime = 0L;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onMouseReleased(int button) {
        if (button == this.lastButton && this.getItemStack() == null && this.cursorDraggable != null) {
            ModularWindow window = this.findHoveredWindow();
            this.cursorDraggable.onDragEnd(this.cursorDraggable.canDropHere(this.hovered, window != null));
            this.cursorDraggable.setMoving(false);
            this.cursorDraggable = null;
            this.lastButton = -1;
            this.lastClickTime = 0L;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onHoveredClick(int button, Object hovered) {
        if ((button == 0 || button == 1) && this.getItemStack() == null && this.cursorDraggable == null) {
            IDraggable draggable;
            if (hovered instanceof IDraggable) {
                draggable = (IDraggable)hovered;
            } else if (hovered instanceof ModularWindow && ((ModularWindow)hovered).isDraggable()) {
                draggable = new DraggableWindowWrapper((ModularWindow)hovered, this.getPos().subtract(((ModularWindow)hovered).getPos()));
            } else {
                return false;
            }
            if (draggable.onDragStart(button)) {
                draggable.setMoving(true);
                this.cursorDraggable = draggable;
                this.lastButton = button;
                this.lastClickTime = Minecraft.func_71386_F();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Widget findHoveredWidget() {
        return this.findHoveredWidget(false);
    }

    @Nullable
    public IDraggable findDraggable() {
        IDraggable draggable = null;
        for (ModularWindow window : this.uiContext.getOpenWindows()) {
            if (!window.isEnabled()) continue;
            AtomicReference hovered = new AtomicReference();
            IWidgetParent.forEachByLayer(window, true, widget -> {
                if (widget instanceof IDraggable && (hovered.get() == null || widget.getLayer() > ((Widget)hovered.get()).getLayer()) && this.isAbove((Widget)widget) && widget.canHover()) {
                    hovered.set(widget);
                }
                return false;
            });
            if (draggable == null && hovered.get() == null && window.isDraggable() && this.isAbove(window)) {
                draggable = new DraggableWindowWrapper(window, this.getPos().subtract(window.getPos()));
                continue;
            }
            if (hovered.get() == null) continue;
            draggable = (IDraggable)hovered.get();
        }
        return draggable;
    }

    @Nullable
    public Widget findHoveredWidget(ModularWindow window) {
        return this.findHoveredWidget(window, false);
    }

    @Nullable
    public Widget findHoveredWidget(boolean forDebug) {
        for (ModularWindow window : this.uiContext.getOpenWindows()) {
            Widget widget;
            if (!window.isEnabled() || (widget = this.findHoveredWidget(window, forDebug)) == null) continue;
            return widget;
        }
        return null;
    }

    @Nullable
    public Widget findHoveredWidget(ModularWindow window, boolean forDebug) {
        AtomicReference hovered = new AtomicReference();
        IWidgetParent.forEachByLayer((IWidgetParent)window, widget -> {
            if ((hovered.get() == null || widget.getLayer() > ((Widget)hovered.get()).getLayer()) && widget.isEnabled() && this.isAbove((Widget)widget) && (forDebug || widget.canHover())) {
                hovered.set(widget);
            }
            return false;
        });
        return (Widget)hovered.get();
    }

    @Nullable
    public ModularWindow findHoveredWindow() {
        for (ModularWindow window : this.uiContext.getOpenWindows()) {
            if (!window.isEnabled() || !this.isAbove(window)) continue;
            return window;
        }
        return null;
    }

    private Widget findHoveredWidgets() {
        this.hoveredWidgets.clear();
        Widget hovered = null;
        LinkedList<IWidgetParent> stack = new LinkedList<IWidgetParent>();
        boolean nextWindow = true;
        for (ModularWindow window : this.uiContext.getOpenWindowsReversed()) {
            if (!window.isEnabled()) continue;
            if (this.isAbove(window)) {
                this.hoveredWidgets.add(0, window);
                hovered = null;
            }
            stack.clear();
            stack.addLast(window);
            while (!stack.isEmpty()) {
                IWidgetParent parent1 = (IWidgetParent)stack.pollFirst();
                for (Widget child : parent1.getChildren()) {
                    if (!child.isEnabled()) continue;
                    boolean above = this.isAbove(child);
                    if (above) {
                        this.hoveredWidgets.add(0, child);
                        if (child.canHover() && (hovered == null || nextWindow || child.getLayer() > hovered.getLayer())) {
                            hovered = child;
                            nextWindow = false;
                        }
                    }
                    if (!(child instanceof IWidgetParent) || ((IWidgetParent)((Object)child)).childrenMustBeInBounds() && !above) continue;
                    stack.addLast((IWidgetParent)((Object)child));
                }
            }
            nextWindow = true;
        }
        return hovered;
    }
}

