/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.common.block.tile.MSMasterTile;
import ru.timeconqueror.lootgames.minigame.minesweeper.GameMineSweeper;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.Vector3i;
import ru.timeconqueror.timecore.api.util.MathUtils;
import ru.timeconqueror.timecore.api.util.client.ClientProxy;
import ru.timeconqueror.timecore.api.util.client.DrawHelper;

public class MSOverlayHandler {
    private static final ArrayList<WeakReference<MSMasterTile>> MS_MASTERS = new ArrayList(1);
    private static final DrawHelper.TexturedRect FIRST_SLOT_START = new DrawHelper.TexturedRect(4.5f, 24.0f, 15.0f, 0.0f, 3.0f, 16.0f);
    private static final DrawHelper.TexturedRect FIRST_SLOT_REPEAT = new DrawHelper.TexturedRect(39.0f, 24.0f, 18.0f, 0.0f, 26.0f, 16.0f);
    private static final DrawHelper.TexturedRect FIRST_SLOT_END = new DrawHelper.TexturedRect(6.0f, 24.0f, 44.0f, 0.0f, 4.0f, 16.0f);
    private static final DrawHelper.TexturedRect EXTRA_SLOT_START = new DrawHelper.TexturedRect(4.5f, 15.0f, 15.0f, 16.0f, 3.0f, 10.0f);
    private static final DrawHelper.TexturedRect EXTRA_SLOT_REPEAT = new DrawHelper.TexturedRect(39.0f, 15.0f, 18.0f, 16.0f, 26.0f, 10.0f);
    private static final DrawHelper.TexturedRect EXTRA_SLOT_END = new DrawHelper.TexturedRect(6.0f, 15.0f, 44.0f, 16.0f, 4.0f, 10.0f);
    public static final ResourceLocation OVERLAY = LootGames.rl("textures/gui/minesweeper/ms_overlay.png");

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            MSOverlayHandler.renderNearbyGameBombs();
            MS_MASTERS.clear();
        }
    }

    private static void renderNearbyGameBombs() {
        EntityPlayer player = ClientProxy.player();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ArrayList<MSMasterTile> masters = new ArrayList<MSMasterTile>(1);
        Iterator<WeakReference<MSMasterTile>> iterator = MS_MASTERS.iterator();
        while (iterator.hasNext()) {
            MSMasterTile master = (MSMasterTile)((Object)iterator.next().get());
            if (master == null) {
                iterator.remove();
                continue;
            }
            GameMineSweeper game = (GameMineSweeper)master.getGame();
            BlockPos gamePos = game.getGameCenter();
            if (MathUtils.distSqr((Vector3i)gamePos, (Entity)player) > (double)(game.getBroadcastDistance() * game.getBroadcastDistance())) {
                iterator.remove();
                continue;
            }
            masters.add(master);
        }
        if (masters.isEmpty()) {
            return;
        }
        boolean extendedInfo = masters.size() > 1;
        float maxRectWidth = 0.0f;
        for (MSMasterTile msMaster : masters) {
            GameMineSweeper game = (GameMineSweeper)msMaster.getGame();
            String toDisplay = MSOverlayHandler.getBombDisplayString(game, extendedInfo);
            maxRectWidth = Math.max(maxRectWidth, (float)fontRenderer.func_78256_a(toDisplay) + 11.0f);
        }
        float startY = 20.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < masters.size(); ++i) {
            MSMasterTile msMaster = (MSMasterTile)((Object)masters.get(i));
            GameMineSweeper game = (GameMineSweeper)msMaster.getGame();
            Color color = game.getStage() instanceof GameMineSweeper.StageDetonating || game.getStage() instanceof GameMineSweeper.StageExploding ? Color.RED : Color.WHITE;
            String toDisplay = MSOverlayHandler.getBombDisplayString(game, extendedInfo);
            float finalMaxRectWidth = maxRectWidth;
            if (i == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(OVERLAY);
                DrawHelper.drawTexturedRectByParts(5.0f, 5.0f, 22.5f, 24.0f, 0.0f, 0.0f, 0.0f, 15.0f, 16.0f, 48.0f);
                DrawHelper.drawWidthExpandableTexturedRect(27.5f, 5.0f, finalMaxRectWidth, 0.0f, FIRST_SLOT_START, FIRST_SLOT_REPEAT, FIRST_SLOT_END, 48.0f);
                DrawHelper.drawYCenteredStringWithShadow(fontRenderer, toDisplay, 33, 17, color.getRGB());
                continue;
            }
            float finalStartY = startY;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(OVERLAY);
            DrawHelper.drawWidthExpandableTexturedRect(27.5f, finalStartY, finalMaxRectWidth, 0.0f, EXTRA_SLOT_START, EXTRA_SLOT_REPEAT, EXTRA_SLOT_END, 48.0f);
            DrawHelper.drawYCenteredStringWithShadow(fontRenderer, toDisplay, 33, (int)(startY + 8.0f), color.getRGB());
            startY += 10.5f;
        }
    }

    private static String getBombDisplayString(GameMineSweeper game, boolean extended) {
        int bombDisplay = game.getStage() instanceof GameMineSweeper.StageDetonating || game.getStage() instanceof GameMineSweeper.StageExploding ? game.getBoard().getBombCount() : game.getBoard().getBombCount() - game.getBoard().cGetFlaggedField();
        BlockPos gamePos = game.getGameCenter();
        return extended ? "x" + bombDisplay + " on " + gamePos.getX() + ", " + gamePos.getY() + ", " + gamePos.getZ() : "x" + bombDisplay;
    }

    public static void addSupportedMaster(MSMasterTile master) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74319_N || Minecraft.func_71410_x().field_71462_r != null) {
            MS_MASTERS.add(new WeakReference<MSMasterTile>(master));
        }
    }
}

