/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseModClient;
import gcewing.sg.SGCraft;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class BaseTexture
implements BaseModClient.ITexture {
    public ResourceLocation location;
    public int tintIndex;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive;
    public boolean isProjected;

    @Override
    public int tintIndex() {
        return this.tintIndex;
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    @Override
    public boolean isEmissive() {
        return this.isEmissive;
    }

    @Override
    public boolean isProjected() {
        return this.isProjected;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public static Sprite fromSprite(IIcon icon) {
        return new Sprite(icon);
    }

    public static Image fromImage(ResourceLocation location) {
        return new Image(location);
    }

    @Override
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    public BaseModClient.ITexture tinted(int index) {
        Proxy result = new Proxy(this);
        result.tintIndex = index;
        return result;
    }

    @Override
    public BaseModClient.ITexture colored(double red, double green, double blue) {
        Proxy result = new Proxy(this);
        result.red = red;
        result.green = green;
        result.blue = blue;
        return result;
    }

    @Override
    public BaseModClient.ITexture emissive() {
        Proxy result = new Proxy(this);
        result.isEmissive = true;
        return result;
    }

    @Override
    public BaseModClient.ITexture projected() {
        Proxy result = new Proxy(this);
        result.isProjected = true;
        return result;
    }

    @Override
    public BaseModClient.ITiledTexture tiled(int numRows, int numCols) {
        return new TileSet(this, numRows, numCols);
    }

    public static class Debug
    extends Sprite {
        public Debug(IIcon icon) {
            super(icon);
        }

        @Override
        public double interpolateU(double u) {
            double iu = super.interpolateU(u);
            SGCraft.log.debug(String.format("BaseTexture: %s u (%s - %s)", this.icon.func_94215_i(), Float.valueOf(this.icon.func_94209_e()), Float.valueOf(this.icon.func_94212_f())));
            SGCraft.log.debug(String.format("BaseTexture: u %s --> %s", u, iu));
            return iu;
        }

        @Override
        public double interpolateV(double v) {
            double iv = super.interpolateV(v);
            SGCraft.log.debug(String.format("BaseTexture: %s v (%s - %s)", this.icon.func_94215_i(), Float.valueOf(this.icon.func_94206_g()), Float.valueOf(this.icon.func_94210_h())));
            SGCraft.log.debug(String.format("BaseTexture: v %s --> %s", v, iv));
            return iv;
        }
    }

    public static class Tile
    extends Proxy {
        protected double u0;
        protected double v0;
        protected double uSize;
        protected double vSize;

        public Tile(TileSet base, int row, int col) {
            super(base);
            this.uSize = base.tileSizeU;
            this.vSize = base.tileSizeV;
            this.u0 = this.uSize * (double)col;
            this.v0 = this.vSize * (double)row;
        }

        @Override
        public double interpolateU(double u) {
            return super.interpolateU(this.u0 + u * this.uSize);
        }

        @Override
        public double interpolateV(double v) {
            return super.interpolateV(this.v0 + v * this.vSize);
        }
    }

    public static class TileSet
    extends Proxy
    implements BaseModClient.ITiledTexture {
        public double tileSizeU;
        public double tileSizeV;

        public TileSet(BaseModClient.ITexture base, int numRows, int numCols) {
            super(base);
            this.tileSizeU = 1.0 / (double)numCols;
            this.tileSizeV = 1.0 / (double)numRows;
        }

        @Override
        public BaseModClient.ITexture tile(int row, int col) {
            return new Tile(this, row, col);
        }
    }

    public static class Solid
    extends BaseTexture {
        public Solid(double red, double green, double blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        @Override
        public boolean isSolid() {
            return true;
        }

        @Override
        public double interpolateU(double u) {
            return 0.0;
        }

        @Override
        public double interpolateV(double v) {
            return 0.0;
        }
    }

    public static class Image
    extends BaseTexture {
        public Image(ResourceLocation location) {
            this.location = location;
        }

        @Override
        public double interpolateU(double u) {
            return u;
        }

        @Override
        public double interpolateV(double v) {
            return v;
        }
    }

    public static class Sprite
    extends BaseTexture {
        public IIcon icon;

        public Sprite(IIcon icon) {
            this.icon = icon;
            this.blue = 1.0;
            this.green = 1.0;
            this.red = 1.0;
        }

        @Override
        public double interpolateU(double u) {
            return this.icon.func_94214_a(u * 16.0);
        }

        @Override
        public double interpolateV(double v) {
            return this.icon.func_94207_b(v * 16.0);
        }

        public String toString() {
            return String.format("BaseTexture.Sprite(%.4f,%.4f,%.4f,%.4f)", this.interpolateU(0.0), this.interpolateV(0.0), this.interpolateU(1.0), this.interpolateV(1.0));
        }
    }

    public static class Proxy
    extends BaseTexture {
        public BaseModClient.ITexture base;

        public Proxy(BaseModClient.ITexture base) {
            this.base = base;
            this.location = base.location();
            this.tintIndex = base.tintIndex();
            this.red = base.red();
            this.green = base.green();
            this.blue = base.blue();
            this.isEmissive = base.isEmissive();
            this.isProjected = base.isProjected();
        }

        @Override
        public boolean isSolid() {
            return this.base.isSolid();
        }

        @Override
        public double interpolateU(double u) {
            return this.base.interpolateU(u);
        }

        @Override
        public double interpolateV(double v) {
            return this.base.interpolateV(v);
        }
    }
}

